% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evt.R
\name{evt.to_dwells}
\alias{evt.to_dwells}
\title{Calculate pulse lengths. Converts transition times to dwell durations.}
\usage{
evt.to_dwells(tables)
}
\arguments{
\item{tables}{Either a single table or a list of tables with columns "states" and "times"}
}
\value{
A segment or a list of segments with one less row, where each row
represents pulse in state 0 (closed dwell) of duration 0.51231, instead
of the time at which the state transitioned.
}
\description{
Calculate pulse lengths. Converts transition times to dwell durations.
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)
head(dwells[[1]])

}
