

opt <- function(x) {
  out <- .opt[[x]]
  if (is.null(out)) stop("Option ", x, " not defined.")
  out
}

opts <- function(...) {
  out <- .opt[c(...)] |> unlist()
  if (is.null(out)) stop("Options not all defined.")
  out
}


# Basic options -----------------------------------------------------------

.opt <- list(
  scdf         = "scdf",
  dv           = "var.values",
  phase        = "var.phase",
  mt           = "var.mt",
  case_name    = "name",
  info         = "info",
  author       = "author",
  rigorous_class_check = TRUE,
  check_arguments = TRUE,
  names_default = paste0("Case", 1:500),
  function_experimental_warning  = paste(
    "This function is in an experimental state.",
    "The syntax and behaviour will probably change in a future version."
  ),
  function_deprecated_warning = paste(
    "This function is deprecated. It might be dropped without any further",
    "notice in a future update of scan."
  ),
  style = list()
  )

.opt$citation <- {
  x <- citation("scan")
  class(x) <- "list"
  attributes(x[[1]])$textVersion
}

.opt$tip <- list(
    "Visit the free online book on scan at: https://jazznbass.github.io/scan-Book/",
    "For information on citing scan, type citation(\"scan\").",
    "Please cite splot (type 'citation(\"scplot\")' for more information).",
    "Start the graphical user interface with shinyscan().",
    "Start scans GUI by clicking 'Addins -> Launch Shiny-Scan'.",
    "Type 'import_scdf()' to start the import helper.",
    "Click 'Addins -> scdf Import' to start the import helper.",
    "Post a question or improvement idea on scan at https://github.com/jazznbass/scan/discussions",
    "Post issues at https://github.com/jazznbass/scan/issues",
    "Find the online help-pages at https://jazznbass.github.io/scan/",
    "The addon package 'scplot' provides sophisticated graphs for single-case data.",
    "Set 'options(scan.export.engine = \"gt\")' and try out the improved table engine for 'export()'.",
    "Use shinyscan to analyse by providing an scdf as an argument, e.g. 'shinyscan(exampleAB)'.",
    "Try out a different visual theme for shinyscan e.g. 'shinyscan(theme = \"united\")'.",
    "Create APA-style html tables with 'export' (e.g. 'hplm(exampleAB) |> export()'."
  )

.opt$startup_message <- paste0(
  "scan ",utils::packageVersion("scan")," (",utils::packageDate('scan'),")\n"
)

