% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeuratLowDim.R
\name{SeuratLowDim}
\alias{SeuratLowDim}
\title{Create a Low dimensional Seurat object from scaled seurat object}
\usage{
SeuratLowDim(scaled_seurat_object, ...)
}
\arguments{
\item{scaled_seurat_object}{A scaled Seurat object.}

\item{...}{Additional arguments to be passed for downstream analyses.}
}
\value{
A Seurat object.
}
\description{
This function converts the transformed data to low-dimensional data for downstream analysis.
}
\examples{
\donttest{
library(Seurat)
# Read 10X counts data from matrix.mtx, barcodes.tsv and genes.tsv
counts <- Read10X(data.dir = "../inst/extdata", gene.column = 1)

# Create Seurat object without batch correction
seurat_obj <- SeuratPreprocess(counts)
seurat_obj <- SeuratLowDim(seurat_obj)
}
}
