% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotateCellsWithSingleR.R
\name{AnnotateCellsWithSingleR}
\alias{AnnotateCellsWithSingleR}
\title{Annotate cells in a Seurat object using SingleR with Celldex}
\usage{
AnnotateCellsWithSingleR(seurat_object, reference_data = NULL, assay = "RNA")
}
\arguments{
\item{seurat_object}{A Seurat object to be annotated.}

\item{reference_data}{A reference dataset to use for annotation (e.g., HumanPrimaryCellAtlasData from Celldex).
If NULL, HumanPrimaryCellAtlasData is used by default.}

\item{assay}{The assay in the Seurat object to use for annotation. Default is "RNA".}
}
\value{
The Seurat object with cell annotations added to the metadata.
}
\description{
This function annotates the cells in a Seurat object using the SingleR package
with reference data obtained from the Celldex package.
}
