% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sbm.R
\name{summary.sbm}
\alias{summary.sbm}
\title{Summarise a linear model}
\usage{
\method{summary}{sbm}(object, ...)
}
\arguments{
\item{object}{A size biased model fit of class \code{\link{sbm}}.}

\item{...}{Additional arguments (unused).}
}
\value{
A dataframe with fields \code{estimate}, \code{stdError},
 \code{tValue}, and \code{pValue}.
}
\description{
For parametric models only, summarises the linear model coefficients from a
an \code{sbm} object.
}
\examples{
  data(BCI_speed_data)
  mod <- sbm(speed~mass, BCI_speed_data, pdf="lnorm")
  summary(mod)
}
