#' Animal speed data
#'
#' A set of animal speed observations recorded by camera traps on Barro
#' Colorado Island, Panama (Rowcliffe et al. 2016).
#'
#' @format A dataframe with  2158 rows and 3 variables:
#' \describe{
#'   \item{species}{character species common names}
#'   \item{speed}{numeric travel speed observations, unit metres per second}
#'   \item{mass}{numeric species average bodey mas, unit kg}
#' }
#' @references Rowcliffe, J.M., Jansen, P.A., Kays, R., Kranstauber, B., and
#'  Carbone, C. (2016). Wildlife speed cameras: measuring animal travel speed
#'  and day range using camera traps. Remote Sensing in Ecology and
#'  Conservation 2, 84-94.
#' @source \url{https://zslpublications.onlinelibrary.wiley.com/doi/full/10.1002/rse2.17}
#' @name BCI_speed_data
#' @docType data
NULL
