% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_skiplinks.R
\name{make_skiplinks}
\alias{make_skiplinks}
\title{Transform an HTML element to a Skip Link}
\usage{
make_skiplinks(element, skip_to, bg_color = "#002240", col = "#FFFFFF")
}
\arguments{
\item{element}{the element to use as a Skip Link}

\item{skip_to}{the HTML element to skip to}

\item{bg_color}{the background color of the element to use as a Skip Link}

\item{col}{the color of the element to use as a Skip Link}
}
\value{
a Skip Link HTML element
}
\description{
Transform an HTML element to a Skip Link
}
\examples{

if (interactive()) {
  ui <- fluidPage(
    tags$a("do you want to be redirected to google.com ?",
      id = "skip-link"
    ) \%>\%
      make_skiplinks(
        skip_to = "https://google.com",
        bg_color = "red",
        col = "white"
      ),

    h1("accessibility is not a detail")
  )

  server <- function(input, output, session) {}

  shinyApp(ui, server)
}
}
