% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_ind_time_matrix}
\alias{get_ind_time_matrix}
\title{Generate a Ind x Time DataFrame from input data}
\usage{
get_ind_time_matrix(Yi, ind, time, orderVect)
}
\arguments{
\item{Yi}{vector of measurements}

\item{ind}{vector of subject identifier (individual) corresponding to each measurement}

\item{time}{vector of time corresponding to each measurement}

\item{orderVect}{if provided, a vector of unique time to be used to order the time columns (otherwise rely on \code{\link[base]{sort}})}
}
\value{
\code{data.frame} of measurements for each IND x TIME. Rows are unique Individual IDs and columns unique measurement Time. Pairs of (IND,TIME) without a measurement are left as NA.
}
\description{
Convert input data with each measurement as a row, to a \code{data.frame} of measurements with Individual as rows and Time as columns. Pairs of Individual and Timepoint without a measurement are left as NA. The resulting \code{data.frame} is employed as input for \code{\link{santaR_fit}}.
}
\examples{
## 6 measurements, 3 subjects, 3 unique time-points
Yi   <- c(1,2,3,4,5,6)
ind  <- c('ind_1','ind_1','ind_1','ind_2','ind_2','ind_3')
time <- c(0,5,10,0,10,5)
get_ind_time_matrix(Yi, ind, time)
#        0  5 10
# ind_1  1  2  3
# ind_2  4 NA  5
# ind_3 NA  6 NA

## 56 measurements, 8 subjects, 7 unique time-points
Yi   <- acuteInflammation$data$var_1
ind  <- acuteInflammation$meta$ind
time <- acuteInflammation$meta$time
get_ind_time_matrix(Yi, ind, time)

}
\seealso{
Other Analysis: 
\code{\link{get_grouping}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_pvalue_dist}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
