% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{sc_cols_unique}
\alias{sc_cols_unique}
\title{Checks that the combination of the specified columns is unique}
\usage{
sc_cols_unique(object, cols = names(object), ...)
}
\arguments{
\item{object}{table with a columns specified by \code{cols}}

\item{cols}{vector of characters which combination is checked to be unique}

\item{...}{further parameters that are passed to \link{add_sanity_check}.}
}
\value{
see return object of \link{add_sanity_check}. Note that if a
  combination appears 3 times, then n_fail will increased by 3.
}
\description{
Checks that the combination of the specified columns is unique
}
\examples{
dummy_call <- function(x) {
  sc_cols_unique(
    object = x,
    cols = c("Species", "Sepal.Length",
             "Sepal.Width", "Petal.Length"))
}
dummy_call(x = iris)
get_sanity_checks()
get_sanity_checks()[["example"]]
}
