% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectRHLP.R
\name{selectRHLP}
\alias{selectRHLP}
\title{selecRHLP implements a model selection procedure to select an optimal RHLP
model with unknown structure.}
\usage{
selectRHLP(X, Y, Kmin = 1, Kmax = 10, pmin = 0, pmax = 4,
  criterion = c("BIC", "AIC"), verbose = TRUE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{Kmin}{The minimum number of regimes (RHLP components).}

\item{Kmax}{The maximum number of regimes (RHLP components).}

\item{pmin}{The minimum order of the polynomial regression.}

\item{pmax}{The maximum order of the polynomial regression.}

\item{criterion}{The criterion used to select the RHLP model ("BIC", "AIC").}

\item{verbose}{Optional. A logical value indicating whether or not a summary
of the selected model should be displayed.}
}
\value{
selectRHLP returns an object of class \link{ModelRHLP}
representing the selected RHLP model according to the chosen \code{criterion}.
}
\description{
selecRHLP implements a model selection procedure to select an optimal RHLP
model with unknown structure.
}
\details{
selectRHLP selects the optimal MRHLP model among a set of model
candidates by optimizing a model selection criteria, including the Bayesian
Information Criterion (BIC). This function first fits the different RHLP
model candidates by varying the number of regimes \code{K} from \code{Kmin} to \code{Kmax}
and the order of the polynomial regression \code{p} from \code{pmin} to \code{pmax}. The
model having the highest value of the chosen selection criterion is then
selected.
}
\examples{
data(univtoydataset)

# Let's select a RHLP model on a time series with 3 regimes:
data <- univtoydataset[1:320,]

selectedrhlp <- selectRHLP(X = data$x, Y = data$y,
                           Kmin = 2, Kmax = 4, pmin = 0, pmax = 1)

selectedrhlp$summary()
}
\seealso{
\link{ModelRHLP}
}
