% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emHMMR.R
\name{emHMMR}
\alias{emHMMR}
\title{emHMMR implemens the EM (Baum-Welch) algorithm to fit a HMMR model.}
\usage{
emHMMR(X, Y, K, p = 3, variance_type = c("heteroskedastic",
  "homoskedastic"), n_tries = 1, max_iter = 1500, threshold = 1e-06,
  verbose = FALSE)
}
\arguments{
\item{X}{Numeric vector of length \emph{m} representing the covariates/inputs
\eqn{x_{1},\dots,x_{m}}.}

\item{Y}{Numeric vector of length \emph{m} representing the observed
response/output \eqn{y_{1},\dots,y_{m}}.}

\item{K}{The number of regimes/segments (HMMR components).}

\item{p}{Optional. The order of the polynomial regression. By default, \code{p} is
set at 3.}

\item{variance_type}{Optional character indicating if the model is
"homoskedastic" or "heteroskedastic" (i.e same variance or different
variances for each of the K regmies). By default the model is
"heteroskedastic".}

\item{n_tries}{Optional. Number of runs of the EM algorithm. The solution
providing the highest log-likelihood will be returned.

If \code{n_tries} > 1, then for the first run, parameters are initialized by
uniformly segmenting the data into K segments, and for the next runs,
parameters are initialized by randomly segmenting the data into K
contiguous segments.}

\item{max_iter}{Optional. The maximum number of iterations for the EM
algorithm.}

\item{threshold}{Optional. A numeric value specifying the threshold for the
relative difference of log-likelihood between two steps of the EM as
stopping criteria.}

\item{verbose}{Optional. A logical value indicating whether or not values of
the log-likelihood should be printed during EM iterations.}
}
\value{
EM returns an object of class \link{ModelHMMR}.
}
\description{
emHMMR implements the maximum-likelihood parameter estimation of the HMMR
model by the Expectation-Maximization (EM) algorithm, known as Baum-Welch
algorithm in the context of HMMs.
}
\details{
emHMMR function implements the EM algorithm for the HMMR model. This
function starts with an initialization of the parameters done by the method
\code{initParam} of the class \link{ParamHMMR}, then it alternates between
the E-Step (method of the class \link{StatHMMR}) and the M-Step
(method of the class \link{ParamHMMR}) until convergence (until the
relative variation of log-likelihood between two steps of the EM algorithm
is less than the \code{threshold} parameter).
}
\examples{
data(univtoydataset)
hmmr <- emHMMR(univtoydataset$x, univtoydataset$y, K = 5, p = 1, verbose = TRUE)

hmmr$summary()

hmmr$plot()

}
\seealso{
\link{ModelHMMR}, \link{ParamHMMR}, \link{StatHMMR}
}
