#' Data from Experiment 1 in \insertCite{zhu2020BayesianSamplerGeneric;textual}{samplrData}
#'
#' Participants made probability judgments of the format: “What is the probability that the weather is \[X\] on a random day in England?". Various weather events were used, and the queries included both marginal events, conditional events, conjunctions, and disjunctions. The total set of 20 unique queries formed a block within which the presentation order was randomized for each participant. The experiment consisted of three blocks, so that all participants responded to each unique query three times.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/mgcxj/).
#' \describe{
#'   \item{ID}{}
#'   \item{block}{3 blocks in total}
#'   \item{trial}{Trial Number within a block}
#'   \item{query, querydetail}{Verbal descriptions of the query}
#'   \item{querytype}{Type of query: e.g. notBgA = p(¬B|A)}
#'   \item{Estimate}{Estimated probability, in percentages}
#'   \item{starttime, endtime}{}
#'   \item{RT}{}
#' }
#' @source <https://osf.io/mgcxj/>
#' @references
#' \insertRef{zhu2020BayesianSamplerGeneric}{samplrData}
"zhu2020.bayesiansampler.e1"

#' Data from Experiment 2 in \insertCite{zhu2020BayesianSamplerGeneric;textual}{samplrData}
#'
#' Participants made probability judgments of the format: “What is the probability that the weather is \[X\] on a random day in England?". Various weather events were used, and the queries included both marginal events, conditional events, conjunctions, and disjunctions. The total set of 20 unique queries formed a block within which the presentation order was randomized for each participant. The experiment consisted of three blocks, so that all participants responded to each unique query three times.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/mgcxj/).
#' \describe{
#'   \item{ID}{}
#'   \item{block}{3 blocks in total}
#'   \item{trial}{Trial Number within a block}
#'   \item{query, querydetail}{Verbal descriptions of the query}
#'   \item{querytype}{Type of query: e.g. notBgA = p(¬B|A)}
#'   \item{Estimate}{Estimated probability, in percentages}
#'   \item{starttime, endtime}{}
#'   \item{RT}{}
#' }
#' @source <https://osf.io/mgcxj/>
#' @references
#' \insertRef{zhu2020BayesianSamplerGeneric}{samplrData}
"zhu2020.bayesiansampler.e2"



#' Data from Experiment 3 in \insertCite{sundh2023UnifiedExplanationVariability;textual}{samplrData}
#'
#' Participants made probability judgments of the format: “What is the probability that the weather is \[X\] on a random day in England?". Various weather events were used, and the queries included both marginal events, conditional events, conjunctions, and disjunctions. The total set of 20 unique queries formed a block within which the presentation order was randomized for each participant. The experiment consisted of three blocks, so that all participants responded to each unique query three times.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/9kea6/).
#' \describe{
#'   \item{ID}{}
#'   \item{block}{3 blocks in total}
#'   \item{trial}{Trial Number within a block}
#'   \item{query, querydetail}{Verbal descriptions of the query}
#'   \item{querytype}{Type of query: e.g. notBgA = p(¬B|A)}
#'   \item{Estimate}{Estimated probability, in percentages}
#'   \item{starttime, endtime}{}
#'   \item{RT}{}
#' }
#' @source <https://osf.io/9kea6/>
#' @references
#' \insertRef{sundh2023UnifiedExplanationVariability}{samplrData}
#'
"sundh2023.meanvariance.e3"

#' Data from Experiment 4 in \insertCite{sundh2023UnifiedExplanationVariability;textual}{samplrData}
#'
#' Participants made probability judgments about future hypothetical events, of the format: “What is the probability that there will be an early UK general election AND the UK economy will recover this year?". The experiment consisted of three blocks, so that all participants responded to each unique query three times.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/9kea6/).
#' \describe{
#'   \item{ID}{}
#'   \item{block}{3 blocks in total}
#'   \item{query, querydetail}{Verbal descriptions of the query}
#'   \item{querytype}{Type of query: e.g. not B given A = p(¬B|A)}
#'   \item{queryset}{Whether the query is about biden and 2050 climate goals or UK election and economic recovery}
#'   \item{Estimate}{Estimated probability, in percentages}
#' }
#' @source <https://osf.io/9kea6/>
#' @references
#' \insertRef{sundh2023UnifiedExplanationVariability}{samplrData}
#'
"sundh2023.meanvariance.e4"

#' Data from Experiment 1 in \insertCite{zhu2022ClarifyingRelationshipCoherence;textual}{samplrData}
#'
#' Participants (from Prolific) estimated the frequencies of different 3-card combinations in a 52 card deck and 3-ball combinations in a 52 ball urn (mathematically identical questions). They also answered surveys on poker playing habits and gamblers fallacy questionnaire.
#'
#' See exact questions in original paper's supplementary materials (Appendix B). These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/cdvkn/).
#' \describe{
#'   \item{group}{Self-reported response on whether they have played poker before}
#'   \item{q1-q9}{Answers to the poker questions}
#'   \item{mq1-mq9}{Answers to the ball questions}
#'   \item{gfs}{number of correct answers in gambler's fallacy questionnaire}
#'   \item{cs}{Inferred poker playing time in the last 12 months}
#'   \item{RT}{}
#'   \item{taskEqual}{judged similarity between the Card and Ball task (0=all equal, 1=all differ, 0.5=answers differ but urn and deck were equal)}
#' }
#' @source <https://osf.io/cdvkn/>
#' @references
#' \insertRef{zhu2022ClarifyingRelationshipCoherence}{samplrData}
#'
"zhu2022.coherenceaccuracy.e1"

#' Data from Experiment 2 in \insertCite{zhu2022ClarifyingRelationshipCoherence;textual}{samplrData}
#'
#' Participants (professional players recruited from twoplustwo.com) estimated the frequencies of different 3-card combinations in a 52 card deck and 3-ball combinations in a 52 ball urn (mathematically identical questions). They also answered surveys on poker playing habits and gamblers fallacy questionnaire.
#'
#' See exact questions in original paper's supplementary materials (Appendix B). These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/cdvkn/).
#' \describe{
#'   \item{group}{value here is always professional (in contrast to Experiment 1)}
#'   \item{q1-q9}{Answers to the poker questions}
#'   \item{mq1-mq9}{Answers to the ball questions}
#'   \item{gfs}{number of correct answers in gambler's fallacy questionnaire}
#'   \item{cs}{Inferred poker playing time in the last 12 months}
#'   \item{RT}{}
#'   \item{taskEqual}{judged similarity between the Card and Ball task (0=all equal, 1=all differ, 0.5=answers differ but urn and deck were equal)}
#' }
#' @source <https://osf.io/cdvkn/>
#' @references
#' \insertRef{zhu2022ClarifyingRelationshipCoherence}{samplrData}
#'
"zhu2022.coherenceaccuracy.e2"

#' Data from Experiment 1 in \insertCite{spicer2022PerceptualCognitiveJudgments;textual}{samplrData}
#'
#' Perceptual judgments. Participants made judgments of numerosity against comparison values or absolute estimates. Comparison values (boundaries) were either similar or dissimilar to the true answer.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/95ruy/).
#' \describe{
#'   \item{Timestamp}{Date and time of the experimental session}
#'   \item{Pt}{Participant ID}
#'   \item{Trial}{Trial ID based on order of presentation}
#'   \item{Boundary}{Comparison value for that trial}
#'   \item{DotCount}{Number of dots shown on that trial}
#'   \item{Region}{Region for that dot count, being either high or low}
#'   \item{Decision}{Decision made by the participant on whether dot count was higher or lower than the boundary for that trial}
#'   \item{Dec_RT}{Response time for the decision}
#'   \item{Accuracy}{Accuracy of the selected decision}
#'   \item{Estimate}{Direct estimate of the number of dots on that trial made by the participant. NaN is used for trials in which no estimate was requested}
#'   \item{Est_RT}{Response time for the estimate}
#' }
#' @source <https://osf.io/95ruy/>
#' @references
#' \insertRef{spicer2022PerceptualCognitiveJudgments}{samplrData}
#'
"spicer2022.anchoringrepulsion.e1"

#' Data from Experiment 2 in \insertCite{spicer2022PerceptualCognitiveJudgments;textual}{samplrData}
#'
#' Cognitive judgments. Participants answered questions about commonly experienced values. judgments of numerosity against comparison values or absolute estimates. Comparison values (boundaries) were either similar or dissimilar to the true answer.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/95ruy/).
#' \describe{
#'   \item{Timestamp}{Date and time of the experimental session}
#'   \item{Pt}{Participant ID}
#'   \item{Trial}{Trial ID based on order of presentation}
#'   \item{QID}{ID for the target question of that trial}
#'   \item{Question}{Question text}
#'   \item{Region}{Expected region for that question, being either high or low}
#'   \item{Answer}{Unbiased answer for that question from calibration data}
#'   \item{Boundary}{Comparison value for that trial}
#'   \item{Decision}{Decision made by the participant on whether answer to the question was higher or lower than the boundary}
#'   \item{Dec_RT}{Response time for the decision}
#'   \item{Accuracy}{Accuracy of the selected decision based on calibration data}
#'   \item{Estimate}{Direct estimate of the answer to the question for that trial made by the participant}
#'   \item{Est_RT}{Response time for the estimate}
#' }
#' @source <https://osf.io/95ruy/>
#' @references
#' \insertRef{spicer2022PerceptualCognitiveJudgments}{samplrData}
#'
"spicer2022.anchoringrepulsion.e2"

#' Data from Experiment 2a in \insertCite{spicer2022PerceptualCognitiveJudgments;textual}{samplrData}
#'
#' Cognitive judgments. Participants answered questions about commonly experienced values. Unlike in Experiment 2, participants viewed each question multiple times, comparing each against both a low (25.5) and high (75.5) comparison value to create 40 trial cases. As in Experiment 1, decisions were requested on all trials, but only 30% of trials were randomly selected to include a direct estimate.
#'
#' This experiment is described in the supplementary materials.
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/95ruy/).
#' \describe{
#'    \item{Timestamp}{Date and time of the experimental session}
#'    \item{Pt}{Unique ID for that participant}
#'    \item{Trial}{Trial ID based on order of presentation}
#'    \item{QID}{ID for the target question of that trial. Note that these IDs match those of the calibration data.}
#'    \item{Question}{Question text for that trial}
#'    \item{Region}{Expected region for that question, being either high or low}
#'    \item{Answer}{Unbiased answer for that question from calibration data}
#'    \item{Boundary}{Comparison value for that trial}
#'    \item{Decision}{Decision made by the participant on whether answer to the question was higher or lower than the boundary for that trial}
#'    \item{Dec_RT}{Response time for the decision}
#'    \item{Accuracy}{Accuracy of the selected decision based on calibration data}
#'    \item{Estimate}{Direct estimate of the answer to the question for that trial made by the participant. NaN is used for trials in which no estimate was requested}
#'    \item{Est_RT}{Response time for the estimate}
#' }
#' @source <https://osf.io/95ruy/>
#' @references
#' \insertRef{spicer2022PerceptualCognitiveJudgments}{samplrData}
#'
"spicer2022.anchoringrepulsion.e2a"

#' Data from Animal Experiment in \insertCite{zhu2022UnderstandingStructureCognitive;textual}{samplrData}
#'
#' Participants were asked to type animal names as they came to mind and were explicitly instructed that they could resubmit previous animals, though not consecutively.
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/kcfgp/).
#' \describe{
#'   \item{ID}{Participant ID}
#'   \item{Order}{Index of the response}
#'   \item{Responses}{Transcribed response}
#'   \item{Animal}{Category the response was allocated to}
#'   \item{StartType,EndType}{Absolute time of starting and ending to type the response}
#'   \item{IRI}{Time between last response's EndType and this response's StartType}
#' }
#' @source <https://osf.io/kcfgp/>
#' @references
#' \insertRef{zhu2022UnderstandingStructureCognitive}{samplrData}
#'
"zhu2022.structurenoise.animals"

#' Data from Time Experiment in \insertCite{zhu2022UnderstandingStructureCognitive;textual}{samplrData}
#'
#' Participants first listened to a sample of the target temporal interval for 60 seconds. Participants were instructed to reproduce the target by pressing the spacebar when they believed the target interval had elapsed (i.e. perfect performance in the task would mean `IRI == Target`).
#'
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/kcfgp/).
#' \describe{
#'   \item{ID}{Participant ID}
#'   \item{Order}{Index of the response}
#'   \item{StartType,EndType}{Absolute time of starting and ending to type the response}
#'   \item{IRI}{Time between last response's EndType and this response's StartType}
#'   \item{Target}{Whether the participant had to reproduce a 1/3s, 1s or 3s interval}
#' }
#' @source <https://osf.io/kcfgp/>
#' @references
#' \insertRef{zhu2022UnderstandingStructureCognitive}{samplrData}
#'
"zhu2022.structurenoise.time"


#' Data from Experiment 1 in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplrData}
#'
#' Participants produced a random sequence of heights of either men or women in the United Kingdom. In one sequence, they sampled heights as distributed according to a uniform distribution (Uniform condition); in the other sequence, heights were distributed following their actual distribution (which is roughly Gaussian).
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/dw8ez/).
#' \describe{
#' \item{id}{participant id}
#' \item{part_Gender}{participant's gender (self-reported)}
#' \item{part_Height}{participant's own height (self-reported)}
#' \item{part_Home}{participant's home country (self-reported)}
#' \item{RQ_Rep}{percentage of correct responses in Randomness Questionnaire, for coin toss pairs where one sequence had too many repetitions}
#' \item{RQ_Alt}{percentage of correct responses in Randomness Questionnaire, for coin toss pairs where one sequence had too many alternations}
#' \item{RQ_GFM}{percentage of correct responses in Randomness Questionnaire, Gambling Fallacies Measure section}
#' \item{minHeight}{height participant reports to be the shortest adult in the UK (from target gender)}
#' \item{maxHeight}{height participant reports to be the tallest adult in the UK (from target gender)}
#' \item{condition}{whether the participant did the uniform condition first (UN) or not (NU)}
#' \item{target_gender}{gender they had to generate heights from, either male (M) or female (F)}
#' \item{index}{position of the item in the sequence, 0 indexed}
#' \item{block}{whether the item belongs to the first sequence the participant uttered (A) or the second (B)}
#' \item{target_dist}{whether the instructions asked for heights as distributed in the population (N) or uniformly distributed (U)}
#' \item{label}{what the participant uttered}
#' \item{unit}{height unit, either centimetres (cm) or feet and inches (f_in).}
#' \item{value}{value in cms of the height uttered.}
#' \item{value_in_units}{value of the height uttered depending on the value of `unit` (either in inches or in centimetres). Used to calculate adjacencies, distances, etc.}
#' \item{starts}{timestamp of when the utterance starts, in seconds.}
#' \item{delays}{temporal difference with the start of the previous item (i.e. `starts[index] - starts[index - 1]`)}
#' \item{R}{whether the item is a repetition of the last}
#' \item{A}{whether the item is adjacent to the last (after removing repetitions)}
#' \item{TP_full}{whether the item is a turning point, considering all items (after removing repetitions)}
#' \item{D}{the Euclidean distance to the previous item (after removing repetitions)}
#' \item{S}{a measure of how likely the item is in a uniform or gaussian distribution (see text)}
#' \item{expected_*}{the expectation for measure `*` derived from reshuffling the participant's sequence 10000 times}
#' }
#' @source <https://osf.io/dw8ez/>
#' @references
#' \insertRef{castillo2024ExplainingFlawsHuman}{samplrData}
#'
"castillo2024.rgmomentum.e1"

#' Data from Experiment 2 in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplrData}
#'
#' Participants first learned a set of syllables arranged in either a single row (one-dimensional condition) or a grid (two-dimensional condition), then produced two random sequences for the same display.
#' These data are licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/), reproduced from materials in [OSF](https://osf.io/dw8ez/).
#' \describe{
#' \item{id}{participant id}
#' \item{part_Gender}{participant's gender (self-reported)}
#' \item{part_Age}{participant's age (self-reported)}
#' \item{index}{position of the item in the sequence, 0 indexed}
#' \item{id}{unique identifier for the participant}
#' \item{block}{whether the item belongs to the first sequence the participant uttered (A) or the second (B)}
#' \item{syll}{syllable uttered}
#' \item{starts}{timestamp of when the utterance starts, in seconds.}
#' \item{delays}{temporal difference with the start of the previous item (i.e. `starts[index] - starts[index - 1]`)}
#' \item{dim}{whether the participant was allocated to the one-dimensional or two-dimensional condition}
#' \item{seed}{Which of five possible configurations the participant learned}
#' \item{position}{The position of the syllable in the array. For 1D arrays, position is left to right. For 2D arrays positions 1-2 correspond to the top 2 cells; 3-5 to the middle 3 cells; and 6-7 to the bottom three cells (always left to right)}
#' \item{R}{whether the item is a repetition of the last}
#' \item{A}{whether the item is adjacent to the last in the display (after removing repetitions)}
#' \item{TP_full}{whether the item is a turning point, considering all items (after removing repetitions)}
#' \item{D}{the Euclidean distance to the previous item (after removing repetitions)}
#' \item{S}{a measure of how likely the item is in a uniform or gaussian distribution (see text)}
#' \item{expected_*}{the expectation for measure `*` derived from reshuffling the participant's sequence 10000 times}
#' }
#' @source <https://osf.io/dw8ez/>
#' @references
#' \insertRef{castillo2024ExplainingFlawsHuman}{samplrData}
#'
"castillo2024.rgmomentum.e2"
