% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds.and.proportions.r
\name{odds.and.proportions}
\alias{odds.and.proportions}
\alias{prop2odds}
\alias{odds2prop}
\alias{effect.size}
\alias{props2theta}
\alias{rr2theta}
\alias{theta2rr}
\title{Interconvert odds and proportion values}
\usage{
prop2odds(p)

odds2prop(o)

effect.size(p, theta)

props2theta(p1, p2)

rr2theta(rr, p1, p2)

theta2rr(theta, p1, p2)
}
\arguments{
\item{p, p1, p2}{Proportion vector.}

\item{o}{Odds vector.}

\item{theta}{Odds ratio vector.}

\item{rr}{Relative risk vector (\code{p1 / p2}).}
}
\value{
A numeric vector.
}
\description{
These functions will create either odds for a given probability,
probability for a given odds, calculate the odds ratio between two
probabilities, or calculate effect size (raise a probability by theta)
}
\examples{
# Convert proportions of 0 through 1 to odds
props <- seq(0,1,0.1)
prop2odds(props)

# Convert odds to proportions
odds2prop(1:3)

# Raise a proportion by an effect size theta
effect.size(0.5, 2)

# Find the odds ratio between two proportions
props2theta(0.75, 0.5)
}
\author{
Paul W. Egeler, M.S.
}
