% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_pivot_longer}
\alias{sm_pivot_longer}
\title{Reshape Column-Based Data to Long Format}
\usage{
sm_pivot_longer(
  data,
  id_cols = intersect(.SAMADB_T, names(data)),
  to_value = setdiff(names(data), id_cols),
  variable_name = "series",
  value_name = "value",
  label_name = "label",
  na.rm = TRUE,
  variable.factor = TRUE,
  label.factor = TRUE,
  ...
)
}
\arguments{
\item{data}{a wide format data frame where all series have their own column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.SAMADB_T}} are selected.}

\item{to_value}{character. The names of all series to be stacked into the long format data frame.}

\item{variable_name}{character. The name of the variable to store the names of the series.}

\item{value_name}{character. The name of the variable to store the data values.}

\item{label_name}{character. The name of the variable to store the series labels.}

\item{na.rm}{logical. \code{TRUE} will remove all missing values from the long data frame.}

\item{variable.factor, label.factor}{logical. \code{TRUE} will code the "series" and "label" columns as factors, which is more memory efficient.}

\item{\dots}{further arguments passed to \code{\link[data.table]{melt}}.}
}
\value{
A \code{\link[data.table]{data.table}} with the reshaped data.
}
\description{
This function automatically reshapes wide (column-based) data into a long format akin to the format of the raw data coming from the database (\code{\link[=sm_data]{sm_data(..., wide = FALSE)}}).
Internally it uses \code{\link[data.table]{melt}} from \emph{data.table}.
}
\examples{
\dontrun{
# Return all electricity indicators from the year 2000 onwards
data <- sm_data("ELECTRICITY", from = 2000)
sm_pivot_longer(data)
}
}
\seealso{
\code{\link{sm_pivot_wider}}, \code{\link{samadb}}
}
