% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_run_report}
\alias{sf_run_report}
\title{Get a report's data in tabular format}
\usage{
sf_run_report(
  report_id,
  report_filters = NULL,
  report_boolean_logic = NULL,
  sort_by = character(0),
  decreasing = FALSE,
  top_n = NULL,
  async = TRUE,
  interval_seconds = 3,
  max_attempts = 200,
  wait_for_results = TRUE,
  guess_types = TRUE,
  bind_using_character_cols = deprecated(),
  fact_map_key = "T!T",
  verbose = FALSE
)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{report_filters}{\code{list}; A \code{list} of reportFilter specifications.
Each must be a list with 3 elements: 1) \code{column}, 2) \code{operator}, and
3) \code{value}. You can find out how certain field types can be filtered by
reviewing the results of \code{\link{sf_list_report_filter_operators}}.}

\item{report_boolean_logic}{\code{character}; a string of boolean logic to parse
custom field filters if more than one is specified. For example, if three filters
are specified, then they can be combined using the logic \code{"(1 OR 2) AND 3"}.}

\item{sort_by}{\code{character}; the name of the column(s) used to sort the results.}

\item{decreasing}{\code{logical}; a indicator of whether the results should be
ordered by increasing or decreasing values in \code{sort_by} column when selecting the
top N records. Note, this argument will be ignored if not specifying Top N. You can
sort the records using \code{\link[dplyr]{arrange}} after the results are returned.}

\item{top_n}{\code{integer}; an integer which sets a row limit filter to a report.
The results will be ordered as they appear in the report unless specified differently
via the \code{sort_by} and \code{decreasing} arguments. Note, it is sometimes
helpful to specify the \code{top_n} argument if a report contains many rows, but
you are only interested in a subset of them. Alternatively, you can limit the count
of returned rows via the \code{report_filters} argument.}

\item{async}{\code{logical}; an indicator, by default set to \code{TRUE}, which
executes the report asynchronously. If executed asynchronously, this function
will return a list of attributes of the created report instance. The results
can be pulled down by providing the report id and instance id to
the function \code{\link{sf_get_report_instance_results}}. Refer to the details
of the documentation on why executing a report asynchronously is preferred.}

\item{interval_seconds}{\code{integer}; defines the seconds between attempts to check
for job completion.}

\item{max_attempts}{\code{integer}; defines then max number attempts to check for job
completion before stopping.}

\item{wait_for_results}{\code{logical}; indicating whether to wait for the
report finish running so that data can be obtained. Otherwise, return the
report instance details which can be used to retrieve the results when the
async report has finished.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used along with \code{anytime()} and \code{anydate()}.
If \code{FALSE} then all fields will be returned as character. Specifying
\code{FALSE} helpful when guessing the column data type will result in NA
values and you would like to return the results as strings and then cast in
your script according to your unique specifications.}

\item{bind_using_character_cols}{\code{logical}; an indicator of whether to
cast the data to all character columns to ensure that \code{\link[dplyr:bind]{bind_rows}}
does not fail because two paginated recordsets have differing datatypes for the
same column. Set this to \code{TRUE} rarely, typically only when having this
set to \code{FALSE} returns an error or you want all columns in the data to be
character.}

\item{fact_map_key}{\code{character}; string providing an index into each
section of a fact map, from which you can access summary and detailed data.
The pattern for the fact map keys varies by report format so it is important
to know what the \code{reportFormat} property of the target report is. See the
note below for more details.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function is a convenience wrapper for retrieving the data from a report.
By default, it executes an asynchronous report and waits for the detailed data
summarized in a tabular format, before pulling them down and returning as a
\code{tbl_df}.
}
\details{
This function is essentially a wrapper around \code{\link{sf_execute_report}}.
Please review or use that function and/or \code{\link{sf_query_report}} if you
want to have more control over how the report is run and what format should
be returned. In this case we've forced the \code{reportFormat="TABULAR"}
without total rows and given options to filter, and select the Top N as
function arguments rather than forcing the user to create an entire list of
\code{reportMetadata}.
}
\note{
Below are the fact map key patterns for three report types:
\describe{
\item{TABULAR}{\code{T!T}: The grand total of a report. Both record data
values and the grand total are represented by this key.}
\item{SUMMARY}{\code{<First level row grouping_second level row grouping_third 
  level row grouping>!T}: T refers to the row grand total.}
\item{MATRIX}{\code{<First level row grouping_second level row grouping>!<First 
  level column grouping_second level column grouping>.}}
}

Each item in a row or column grouping is numbered starting with 0. Here are
some examples of fact map keys:

\describe{
\item{0!T}{The first item in the first-level grouping.}
\item{1!T}{The second item in the first-level grouping.}
\item{0_0!T}{The first item in the first-level grouping and the first item
in the second-level grouping.}
\item{0_1!T}{The first item in the first-level grouping and the second item
in the second-level grouping.}
}
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_getreportrundata.htm}{Sync Documentation}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_get_reportdata.htm#example_sync_reportexecute}{Sync Example}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_instances_summaryasync.htm}{Async Documentation}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_get_reportdata.htm#example_report_async_instances}{Async Example}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/sforce_analytics_rest_api_filter_reportdata.htm#example_requestbody_execute_resource}{Filtering Results}
}
}

\examples{
\dontrun{
# find a report in your org and run it
all_reports <- sf_query("SELECT Id, Name FROM Report")
this_report_id <- all_reports$Id[1]
results <- sf_run_report(this_report_id)

# apply your own filters to that same report
# set up some filters, if needed
# filter records that was created before this month
filter1 <- list(column = "CREATED_DATE",
                operator = "lessThan", 
                value = "THIS_MONTH")

# filter records where the account billing address city is not empty
filter2 <-  list(column = "ACCOUNT.ADDRESS1_CITY",
                 operator = "notEqual", 
                 value = "")

# combine filter1 and filter2 using 'AND' so that records must meet both filters
results_using_AND <- sf_run_report(my_report_id, 
                                   report_boolean_logic = "1 AND 2",
                                   report_filters = list(filter1, filter2))

# combine filter1 and filter2 using 'OR' which means that records must meet one 
# of the filters but also throw in a row limit based on a specific sort order
results_using_OR <- sf_run_report(my_report_id, 
                                  report_boolean_logic = "1 OR 2",
                                  report_filters = list(filter1, filter2), 
                                  sort_by = "Contact.test_number__c", 
                                  decreasing = TRUE, 
                                  top_n = 5)
}
}
\seealso{
Other Report functions: 
\code{\link{sf_copy_report}()},
\code{\link{sf_create_report}()},
\code{\link{sf_delete_report}()},
\code{\link{sf_describe_report}()},
\code{\link{sf_describe_report_type}()},
\code{\link{sf_execute_report}()},
\code{\link{sf_list_report_fields}()},
\code{\link{sf_list_report_filter_operators}()},
\code{\link{sf_list_report_types}()},
\code{\link{sf_list_reports}()},
\code{\link{sf_query_report}()},
\code{\link{sf_update_report}()}
}
\concept{Report functions}
