% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-length-dim-names.r
\name{shape}
\alias{shape}
\alias{length.dual}
\alias{dim.dual}
\alias{names.dual}
\alias{dimnames.dual}
\alias{dim<-.dual}
\alias{dimnames<-.dual}
\alias{names<-.dual}
\title{Dual objects length, dim, names and dimnames}
\usage{
\method{length}{dual}(x)

\method{dim}{dual}(x)

\method{dim}{dual}(x) <- value

\method{dimnames}{dual}(x)

\method{dimnames}{dual}(x) <- value

\method{names}{dual}(x)

\method{names}{dual}(x) <- value
}
\arguments{
\item{x}{a dual object}

\item{value}{for replacement methods, the new value}
}
\value{
Return values are similar to the base methods.
}
\description{
S3 methods for length, dim, names and dimnames
}
\details{
As the methods `dimnames` and `dimnanes<-.dual` have been defined,
you can use `rownames` and `colnames` as with numeric matrices (see examples).
}
\examples{
x <- dual( matrix(c(1,0,2,3,2,4), 2, 3) )
dim(x)
length(x)
rownames(x) <- c("L1", "L2")
x
d(x, "x1.1")

# modifying dim is the recommended way to change dual object shape
dim(x) <- NULL
x

# back to matrix shape
dim(x) <- c(2, 3)
x
}
