% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{computeNPlanSafeT}
\alias{computeNPlanSafeT}
\title{Helper function: Computes the planned sample size of the safe t-test based on the
minimal clinical relevant standardised mean difference.}
\usage{
computeNPlanSafeT(
  deltaMin,
  beta = 0.2,
  alpha = 0.05,
  alternative = c("twoSided", "less", "greater"),
  testType = c("oneSample", "paired", "twoSample"),
  lowN = 3,
  highN = 1e+06,
  ratio = 1,
  nSim = 1000L,
  nBoot = 1000L,
  parameter = NULL,
  pb = TRUE,
  nMax = 1e+06,
  seed = NULL
)
}
\arguments{
\item{deltaMin}{numeric that defines the minimal relevant standardised effect size, the smallest effect size that
we would the experiment to be able to detect.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both
the sample sizes and deltaS, which defines the test. Note that 1-beta defines the power.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent of n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "twoSided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{lowN}{integer minimal sample size of the (first) sample when computing the power due to
optional stopping. Default lowN is set 1.}

\item{highN}{integer minimal sample size of the (first) sample when computing the power due to
optional stopping. Default highN is set 1e6.}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{nMax}{integer > 0, maximum sample size of the (first) sample in each sample path.}

\item{seed}{integer, seed number.}
}
\value{
a list which contains at least nPlan and an adapted bootObject of class  \code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the planned sample size of the safe t-test based on the
minimal clinical relevant standardised mean difference.
}
\examples{
computeNPlanSafeT(0.7, 0.2, nSim=10)
}
