% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{computeBetaBatchSafeZ}
\alias{computeBetaBatchSafeZ}
\title{Helper function: Computes the type II error based on the minimal clinically relevant effect size and sample size.}
\usage{
computeBetaBatchSafeZ(
  meanDiffMin,
  nPlan,
  alpha = 0.05,
  sigma = 1,
  kappa = sigma,
  alternative = c("twoSided", "greater", "less"),
  testType = c("oneSample", "paired", "twoSample"),
  parameter = NULL
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "twoSided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}
}
\value{
numeric that represents the type II error
}
\description{
Helper function: Computes the type II error based on the minimal clinically relevant effect size and sample size.
}
