#' @title Sample Data for Small Area Estimation with Measurement Error using Hierarchical Bayesian Method under Student-t Distribution
#' @description This data generated by simulation based on Hierarchical Bayesian Method under Student-t Distribution with Measurement Error by following these steps:
#' \enumerate{
#'   \item Generate \eqn{x_{1}}{x1} ~ UNIF(10, 20) and \eqn{x_{2}}{\x2} ~ UNIF(30,50)
#'   \item Generate \eqn{v.x_{1}}{v.x1} ~ 1/(Gamma(1,1))
#'   \item Generate \eqn{x_{1h}}{x1h} ~ N(\eqn{x_{1}}{x1}
#'   \item Generate \eqn{\beta_{0}}{\beta0} = \eqn{\beta_{1}}{\beta1} = \eqn{\beta_{2}}{\beta2} = 0.5
#'   \item Generate \eqn{u}{u} ~ N(0,1) and \eqn{k}{k} ~ Gamma(10,1)
#'   \item Calculate \eqn{\mu}{\mu} = \eqn{\beta_{0} + \beta_{1}*x_{1h} + \beta_{2}*x_{2h} + u}{\beta0 + \beta1*x1h + \beta2*x2h + u}
#'   \item Generate \eqn{Y}{Y} ~ t(\eqn{k}{k}, \eqn{\mu}{\mu})) and \eqn{v}{v} = \eqn{\sigma_{y}^{2}}{\sigmay2}
#' }
#' Direct estimation \code{Y}, auxiliary variables \code{x1 x2 x3 x4}, sampling variance \code{v}, and mean squared error of auxiliary variables \code{v.x1 v.x2} are arranged in a dataframe called \code{dataTMEHB}.
#' @usage data(dataTMEHB)
#' @format A data frame with 30 observations on the following 8 variables.
#' \describe{
#'  \item{\code{Y}}{direct estimation of Y.}
#'  \item{\code{x1}}{auxiliary variable of x1.}
#'  \item{\code{x2}}{auxiliary variable of x2.}
#'  \item{\code{vardir}}{sampling variances of Y.}
#'  \item{\code{v.x1}}{mean squared error of x1.}
#' }
#' @name dataTMEHB
NULL
