% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCAs.R
\name{LCAs}
\alias{LCAs}
\title{Construct a poset of latent class analysis models.}
\usage{
LCAs(maxNumClasses = 1, numVariables = 2,
     numStatesForVariables = 2, phi = "default")
}
\arguments{
\item{maxNumClasses}{the number of classes in the largest LCA model to
considered.}

\item{numVariables}{the number of observed variables.}

\item{numStatesForVariables}{the number of states for each observed variable,
at the moment these must all be equal.}

\item{phi}{parameter controlling the strength of the sBIC penalty.}
}
\value{
An object representing the collection.
}
\description{
Creates an object representing a collection of latent class analysis models.
There is one model for each fixed number of latent classes from 1 to some
specified maximum. In particular each model is identified by a single number
specifiying the number of latent classes in the model. Models are naturally
ordered by inclusion so that, for example, a model with 2 latent classes
comes before a model with 3 or more latent classes.
}

