% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological.autocorr.R
\name{topological.autocorr}
\alias{topological.autocorr}
\title{Calculate data for autocorrelation plots of tree topologies from MCMC analyses}
\usage{
topological.autocorr(
  chains,
  burnin = 0,
  max.sampling.interval = NA,
  autocorr.intervals = 100,
  squared = FALSE,
  treedist = "PD",
  use.all.samples = FALSE
)
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{max.sampling.interval}{The largest sampling interval for which you want to calculate the mean distance between pairs of trees (default is 10 percent of the length of the list of trees).}

\item{autocorr.intervals}{The number of sampling intervals to use. These will be spaced evenly between 1 and the max.sampling.interval}

\item{squared}{TRUE/FALSE use squared tree distances (necessary to calculate approximate ESS)}

\item{treedist}{the type of tree distance metric to use, can be 'PD' for path distance or 'RF' for Robinson Foulds distance}

\item{use.all.samples}{(TRUE/FALSE). Whether to calculate autocorrelation from all possible pairs of trees in your chain. The default is FALSE, in which case 500 samples are taken at each sampling interval. This is sufficient to get reasonably accurate estimates of the approximate ESS. Setting this to TRUE will give you slightly more accurate ESS estimates, at the cost of potentially much longer execution times.}
}
\value{
A data frame with one row per sampling interval, per chain. 
The first column is the sampling interval. The second column is the mean 
path distance between pairs of trees from that sampling interval. The third
column is the chain ID.
}
\description{
This function takes a list of rwty.chain objects, and calculates the
mean phylogenetic distance at a series of roughly even sampling intervals.
In really well behaved MCMC analyses, the mean distance will stay constant
as the sampling interval increases. If there is autocorrelation, it will 
increase as the sampling interval increases, and is expected to level
off when the autocorrelation decreases to zero. The function calculates
path distances, though other distances could also be employed.
}
\examples{
\dontrun{
data(fungus)
topological.autocorr(fungus, burnin = 20)
}
}
\keyword{autocorrelation}
\keyword{distance}
