% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_runners.R
\name{construct_runners}
\alias{construct_runners}
\title{Construct runners}
\usage{
construct_runners(
  os = c("ubuntu-latest", "macOS-latest", "windows-latest"),
  bioc = list("devel", "release", "release"),
  r = list("auto", "auto", "auto"),
  python_version = list(NULL, NULL, NULL),
  versions_explicit = FALSE,
  run_check_cont = FALSE,
  cont = construct_cont(default_tag = bioc[[1]], run_check_cont = run_check_cont),
  rspm = list(NULL, NULL, NULL),
  verbose = TRUE
)
}
\arguments{
\item{os}{Which OS to launch GitHub Actions on. 
See \href{https://github.com/actions/runner-images}{here for all options}.}

\item{bioc}{Which Bioconductor version to use on each OS. 
See \link[rworkflows]{bioc_r_versions} documentation for all options.}

\item{r}{Which R version to use on each OS.}

\item{python_version}{Which python version to use on each OS
(e.g. "3.10", "3.7.5", or "3.x").
(\code{NULL} means python will not be installed on that OS).
See 
\href{https://github.com/actions/python-versions}{here} 
or  \code{rworkflows:::gha_python_versions()} for all available 
python versions. 
See 
\href{https://github.com/marketplace/actions/setup-miniconda}{here} for
details on the \code{actions/setup-miniconda} action.
See \href{https://github.com/actions/setup-python}{here} for details on 
the \code{actions/setup-python} action.}

\item{versions_explicit}{Specify R/Bioc versions explicitly
(e.g. \code{r: 4.2.0, bioc: 3.16}) 
as opposed to flexibly (e.g. \code{r: "latest", bioc: "release"}).}

\item{run_check_cont}{Check whether the requested container repo 
(and the tag, if specified) exist using \link[rworkflows]{check_cont}.}

\item{cont}{Which Docker container to use on each OS
(\code{NULL} means no container will be used for that OS).
See 
\href{https://hub.docker.com/r/bioconductor/bioconductor_docker/tags}{here}
 for a list of all official Bioconductor Docker container versions.}

\item{rspm}{Which R repository manager to use on each OS
(\code{NULL} means the default will be used for that OS).}

\item{verbose}{Print messages.}
}
\value{
Named list of configurations for each runner OS.
}
\description{
Construct runner configurations across multiple Operating Systems (OS)
 for GitHub Actions workflow.
}
\examples{
runners <- construct_runners()
}
