% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dw_preprocess.R
\name{dw_preprocess}
\alias{dw_preprocess}
\title{Pre-processes a data frame of deaths, exposed to risk or times of exposition to be used by the `dw_crude_mx` function}
\usage{
dw_preprocess(x, age.min = 0, age.max = 120)
}
\arguments{
\item{x}{A data frame (or matrix) of deaths, exposed to risk or times of exposition with ages as first column.}

\item{age.min}{A non-negative integer indicating the minimum age for the output object. Default, 0.}

\item{age.max}{A non-negative integer indicating the maximum age for the output object. Default, 120.}
}
\value{
A data.frame containing the same columns as `x` except for the first one, as outlined in the function's description.
}
\description{
This function pre-processes a data frame (or matrix) of deaths,
             exposed to risk or times of exposition to be used by the
             `dw_crude_mx` function when the data frame has a variable of ages
             in the first column and likely data are non-available for all the
             sequence of ages desired by the user. It creates a new data frame by
             inserting zeroes in the cells corresponding to the missing ages.
}
\examples{

deaths <- structure(list(ages = c(67, 69:78),
                         Year2017 = c(144, 102, 113, 122, 156, 110, 126, 132, 120, 172, 110),
                         Year2018 = c(111, 122, 109, 116, 162, 154, 115, 146, 100, 169, 146),
                         Year2019 = c(100, 123, 113, 151, 122, 110, 137, 175, 137, 110, 155)),
                         class = "data.frame", row.names = 1:11)

example <- dw_preprocess(x = deaths)

}
\author{
Jose M. Pavia \email{pavia@uv.es}
}
