% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarball.R
\name{r_release_tarball}
\alias{r_release_tarball}
\title{Latest release for which a source tarball is available for download}
\usage{
r_release_tarball()
}
\value{
A one row data frame, with columns \sQuote{version},
\sQuote{date}, \sQuote{URL} and \sQuote{nickname}.
}
\description{
\code{\link[=r_release]{r_release()}} works based on the SVN tags in the main R source code
repository. However, an SVN tag does not mean that the same version
is available for download. \code{r_release_tarball} returns the latest
version for which a source tarball is available.
}
\section{Note}{

This function is superseded by \code{\link[=resolve]{resolve()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{r_release_tarball()
#> # A data frame: 1 x 5
#>   version date                nickname          semver     URL                  
#>   <chr>   <dttm>              <chr>             <pckg_vrs> <chr>                
#> 1 4.5.1   2025-06-13 07:12:01 Great Square Root 4.5.1      https://cran.rstudio~
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{resolve("release", platform = NA)
#> # A data frame: 1 x 6
#>   version date                nickname          semver     url             type 
#>   <chr>   <dttm>              <chr>             <pckg_vrs> <chr>           <chr>
#> 1 4.5.1   2025-06-13 07:12:01 Great Square Root 4.5.1      https://cran.r~ rele~
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
r_release()
r_release_tarball()
\dontshow{\}) # examplesIf}
}
\seealso{
Other R downloads: 
\code{\link{r_release_macos}()},
\code{\link{r_release_win}()}
}
\concept{R downloads}
