% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{GM_X_cond_vol_no_skew}
\alias{GM_X_cond_vol_no_skew}
\title{GARCH-MIDAS-X conditional volatility (without skewness)}
\usage{
GM_X_cond_vol_no_skew(param, daily_ret, X, mv_m, K, lag_fun = "Beta")
}
\arguments{
\item{param}{Vector of estimated values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{X}{Additional "X" variable, which must be an "xts" object. Morever, "X" must be observed for the same days of daily_ret.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is an "xts" object representing the conditional volatility.
}
\description{
Obtains the estimated conditional volatility for the GARCH-MIDAS-X model, without the skewness parameter in the short--run.
For details, see \insertCite{engle_ghysels_sohn_2013;textual}{rumidas} and \insertCite{conrad_lock_2015;textual}{rumidas}.
}
\examples{
\donttest{
est_val<-c(alpha=0.01,beta=0.8,z=0.1,m=2,theta=0.1,w2=2)
r_t<-sp500['/2010']
X<-rv5['/2010']^0.5
mv_m<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
head(GM_X_cond_vol_no_skew(est_val,r_t,X,mv_m,K=12))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
