% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ds_competimer}
\alias{ds_competimer}
\title{Competimer set}
\format{
\subsection{\code{ds_competimer}}{

A data frame with 6,615 rows and 10 columns:
\describe{
\item{\code{well}}{Well identifier.}
\item{\code{replicate}}{Replicate identifier.}
\item{\code{dye}}{In all reactions the SYBR Green I master mix (Roche) was used,
so the value is always \code{"SYBR"}.}
\item{\code{pct}}{Percentage of competitive (aminated) primers in the mix.}
\item{\code{conc}}{Concentration of reference human genomic DNA (Roche): from 64
ng/µl down to 0.0625 ng/µl.}
\item{\code{target}}{Target identifier: AluSx.}
\item{\code{sample_type}}{Sample type: \code{"ntc"} (no template control) or \code{"std"} (standard).}
\item{\code{dilution}}{Dilution factor (the reciprocal of \code{conc}, i.e. \code{64 / conc}). Higher number
means greater dilution.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
}
\source{
\url{https://medischebiologie.nl/wp-content/uploads/2019/02/qpcrdatamethods.zip}
}
\usage{
ds_competimer
}
\description{
Competitive primers were synthesized on basis of identical sequence and
blocked by amination at the 3' end to allow annealing, but avoid elongation
during the PCR process.

A six-point 4-fold serial dilution series made from reference human genomic
DNA (Roche), starting from 64 ng/µl down to 0.0625 ng/µl, was created in 10
ng/µl yeast tRNA as carrier. The same dilution of the carrier was used to
create a NTC sample.

qPCR amplifications were performed in 7.5 µl total reaction volume containing:
\itemize{
\item 3.75 µl 2x custom made qPCR SYBR green I Mastermix (Eurogentec)
\item 0.375 µl forward primer (5 µM) and 0.375 µl reverse primer (5 µM)
\item 1 µl of a mixture of nuclease-free water and equal amounts of both forward and reverse competitive (aminated) primers
\item 2 µl diluted standard
}

A total of 7 competitive mixes were prepared for each dilution point,
containing 0\%, 5\%, 10\%, 20\%, 30\%, 40\%, and 50\% (of the total amount of
primer) competitive (aminated) forward and reverse primers. Each reaction was
run in triplicate.

The qPCR cycling was performed on the LightCycler480 (Roche) using white
LightCycler480 384-multiwell plates with Light-Cycler480 sealing foils
(Roche).

The cycling conditions were com  prised of 10 min polymerase activation at 95
°C, and 45 cycles of 15 s at 95 °C, 30 s at 60 °C, followed by a dissociation
curve analysis from 60 to 95 °C.
}
\keyword{datasets}
