% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{create_theme}
\alias{create_theme}
\alias{get_theme}
\alias{get_themes}
\alias{update_theme}
\alias{delete_theme}
\title{Theme functions}
\usage{
create_theme(
  name,
  api = NULL,
  background_href = NULL,
  background_layout = "fullscreen",
  background_brightness = 0,
  colors_answer = "#4FB0AE",
  colors_background = "#FFFFFF",
  colors_button = "#4FB0AE",
  colors_question = "#3D3D3D",
  font = "Source Sans Pro",
  has_transparent_button = TRUE
)

get_theme(theme_id, api = NULL)

get_themes(api = NULL, page = 1, page_size = 10)

update_theme(
  theme_id,
  name,
  api = NULL,
  background_href = NULL,
  background_layout = "fullscreen",
  background_brightness = 0,
  colors_answer = "#4FB0AE",
  colors_background = "#FFFFFF",
  colors_button = "#4FB0AE",
  colors_question = "#3D3D3D",
  font = "Source Sans Pro",
  has_transparent_button = TRUE
)

delete_theme(theme_id, api = NULL)
}
\arguments{
\item{name}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{api}{Default \code{NULL}. Your private api key. If \code{api} is \code{NULL},
the environment variable \code{Sys.getenv("typeform_api2")} is used.}

\item{background_href}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{background_layout}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{background_brightness}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{colors_answer}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{colors_background}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{colors_button}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{colors_question}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{font}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{has_transparent_button}{See https://www.typeform.com/developers/create/reference/create-theme/}

\item{theme_id}{The theme id}

\item{page}{The page of results to retrieve. Default 1 is the first page of results.}

\item{page_size}{Number of results to retrieve per page. Default is 10. Maximum is 200.}
}
\description{
Theme API functions
}
