% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocoding.R
\name{rtry_geocoding}
\alias{rtry_geocoding}
\title{Perform geocoding}
\usage{
rtry_geocoding(address, email)
}
\arguments{
\item{address}{String of an address.}

\item{email}{String of an email address.}
}
\value{
A data frame that contains latitudes (lat) and longitudes (lon) in WGS84 projection.
}
\description{
This function uses \href{https://wiki.openstreetmap.org/wiki/Nominatim}{Nominatim},
a search engine for OpenStreetMap (OSM) data, to perform geocoding,
i.e. converting an address into coordinates (latitudes, longitudes).
The data provided by OSM is free to use for any purpose, including commercial use,
and is governed by the distribution license \href{https://wiki.osmfoundation.org/wiki/Licence}{ODbL}.
}
\examples{
\dontrun{
# Convert the address of MPI-BGC ("Hans-Knoell-Strasse 10, 07745 Jena, Germany")
# into coordinates in latitudes and longitudes
# Note: Please change to your own email address when executing this function
rtry_geocoding("Hans-Knoell-Strasse 10, 07745 Jena, Germany",
   email = "john.doe@example.com")

# Expected message:
#        lat      lon
# 1 50.9101 11.56674
}

# Learn to perform geocoding to a list of locations via the vignette (Workflow for
# geocoding using rtry): vignette("rtry-workflow-geocoding").
}
\seealso{
\code{\link{rtry_revgeocoding}}
}
