% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_row.R
\name{rtry_bind_row}
\alias{rtry_bind_row}
\title{Bind data by rows}
\usage{
rtry_bind_row(..., showOverview = TRUE)
}
\arguments{
\item{\dots}{A list of data frames or data tables to be combined by rows.}

\item{showOverview}{Default \code{TRUE} displays the dimension and column names of the combined data.}
}
\value{
An object of the same type as the first input. The object will contain a column if that column
appears in any of the inputs.
}
\description{
This function takes a list of data frames or data tables and combines them by rows,
it adds the rows of the second data below the rows of the first one.
}
\note{
A common attribute is not necessary (difference to the function \code{\link{rtry_join_left}} and \code{\link{rtry_join_outer}}):
the binding process simply puts the data one after another while matching the column names, and any missing columns will be
filled with \code{NA}.
}
\examples{
# Combine the two provided sample data (data_TRY_15160 and data_TRY_15161)
data <- rtry_bind_row(data_TRY_15160, data_TRY_15161)

# Expected message:
# dim:   6409 28
# col:   LastName FirstName DatasetID Dataset SpeciesName AccSpeciesID AccSpeciesName
#        ObservationID ObsDataID TraitID TraitName DataID DataName OriglName
#        OrigValueStr OrigUnitStr ValueKindName OrigUncertaintyStr UncertaintyName
#        Replicates StdValue UnitName RelUncertaintyPercent OrigObsDataID ErrorRisk
#        Reference Comment V28
}
\references{
This function makes use of the \code{\link[dplyr]{bind_rows}} function within the \code{dplyr} package.
}
\seealso{
\code{\link{rtry_bind_col}}, \code{\link{rtry_join_left}}, \code{\link{rtry_join_outer}}
}
