% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsPeak.R
\name{rtmsPeak}
\alias{rtmsPeak}
\title{Create an RTMS m/z Peak Object}
\usage{
rtmsPeak(
  value,
  peakWidth = 0.1,
  windowWidth = NULL,
  bounds = NULL,
  window = NULL
)
}
\arguments{
\item{value}{The m/z value that the peak is intended to measure}

\item{peakWidth}{The width of the peak centered on \code{value}. If a single
numeric value, the lower bound of the peak will lie \code{peakWidth/2} below
\code{value},and the upper bound will lie \code{peakWidth/2} above \code{value}.  If a
vector of two numeric values, the first value specifies how far below \code{value}
the lower bound lies, and the second value specifies how far above \code{value}
the upper bound lies.  If parameter \code{bounds} is not null, this parameter will
be ignored.}

\item{windowWidth}{The width of the optional wider window around \code{value}
used to show the peak in context.  Operates by the same principles as
\code{peakWidth} with a single value split evenly between lower and upper bounds,
and two values specifying how far below and above \code{value} each bound lies. If
parameter \code{window} is not null, this parameter will be ignored.}

\item{bounds}{If not null, a two-value numeric vector specifying the lower
and upper m/z bounds of the measured peak. One of \code{bounds} or \code{peakWidth}
must be not null, and if \code{bounds} is not null, then \code{peakWidth} will be
ignored.}

\item{window}{If not null, a two-value numeric vector specifying the lower
and upper m/z bounds of the wider context window of the peak. If \code{window} is
not null, then \code{windowWidth} will be ignored.}
}
\value{
An object of class \code{rtmsPeak}, used by RTMS functions to extract
and measure peaks from mass spectra.
}
\description{
Generates an object of class \code{rtmsPeak} which contains the m/z values
bounding a spectrometric peak to be measured.  A peak object specifies not
only the m/z value at the cetner of the peak, but the upper and lower bounds
within which the peak is to be quantified; it also may optionally include
wider upper and lower bounds used to plot the peak in a wider context of the
spectrum.
}
\examples{
peaks <- rtmsPeak(1516.83,peakWidth=0.2,windowWidth = c(5,10))
}
