% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsPlotting.R
\name{plotRtmsSample}
\alias{plotRtmsSample}
\title{Plot an RTMS sample object}
\usage{
plotRtmsSample(sample, usePeakNames = TRUE, freey = TRUE)
}
\arguments{
\item{sample}{An object of class \code{rtmsSample}.}

\item{usePeakNames}{If the list of peaks used to create the sample was a
named list, then setting this to TRUE (the default) will use those names to
label the facets of the plotted sample. If set to FALSE, the facets will be
labelled with the m/z values of each peak.  This parameter will be ignored if
the peaks are unnamed.}

\item{freey}{If TRUE (the default) the y-axes of each peak's facet will be
allowed to vary freely, so different peaks will be plotted on different
scales.  Setting this to FALSE will fix all peaks with in a sample on the
same y-axis scale.}
}
\value{
A \code{ggplot} object depicting the RTMS sample.
}
\description{
\code{plotRtmsSample()} takes an RTMS sample object and produces a \code{ggplot} object
depicting all extracted peaks, and their context windows if included.
}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
sample <- getSample(exampleSpectrum,peaks)

plot1 <- plotRtmsSample(sample)
plot2 <- plotRtmsSample(sample,freey=FALSE)
}
