% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsMeasurement.R
\name{measureSample}
\alias{measureSample}
\title{Measure peaks in an RTMS sample}
\usage{
measureSample(sample, measure = "PeakIntensity")
}
\arguments{
\item{sample}{An object of class \code{rtmsSample}}

\item{measure}{A character vector of named measurements, or a list of
custom measurement functions.  Supported measurement names are
"PeakIntensity", which takes the total of any local maxima within the peak
width, "PeakArea", which takes the area under the intensity curve within the
peak width, and "NumPeaks", which counts the local maxima in the peak window.
If \code{measure} is a list of functions, each function must take an object of
class \code{rtmsSubsample}, and return a single numeric value.  If the functions
are named, those names will be returned in the "measure" column of the
resulting data frame; otherwise they will be identified as "Measure1",
"Measure2", etc.}
}
\value{
A data frame with one row for each peak and measurement in the
sample. The data.frame will have a column named "peakName" with the name of
the relevant peak  (if  the "peaks" attribute of \code{sample} is a named list);
a column named "peakValue" containing the m/z value at the center of the
relevant peak; a column named "measure" containing the name of the relevant
measure; and a column named "value" containing the numeric value of the
particular measure for that peak.
}
\description{
\code{measureSample()} extracts one or more measurements for every peak in
an RTMS sample object (of class \code{rtmsSample}).
}
\examples{
peaks <- rtmsPeakList(c(1516.83,1530.84),peakWidth=0.2,windowWidth = c(5,10))
names(peaks) <- c("Product","Substrate")
sample <- getSample(exampleSpectrum,peaks)

measure <- measureSample(sample,c("PeakArea","PeakIntensity"))

myFunctions <- list(PeakRawIntensity = function(s) max(s$peakPiece$intensity))
myMeasures <- measureSample(sample,myFunctions)
}
