% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tide-height.R
\name{tide_height}
\alias{tide_height}
\title{Tide Height}
\usage{
tide_height(
  stations = "Monterey Harbor",
  minutes = 60L,
  from = as.Date("2015-01-01"),
  to = as.Date("2015-01-01"),
  tz = "UTC",
  harmonics = rtide::harmonics
)
}
\arguments{
\item{stations}{A character vector of stations to match - treated as regular expressions.}

\item{minutes}{An integer of the number of minutes between tide heights}

\item{from}{A Date of the start of the period of interest}

\item{to}{A Date of the end of the period of interest}

\item{tz}{A string of the time zone.}

\item{harmonics}{The harmonics object.}
}
\value{
A data frame of the tide heights in m by the number of minutes for each station from from to to.
}
\description{
Calculates tide height at specified stations based on the supplied harmonics object.
}
