% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt3.R
\docType{package}
\name{rt3}
\alias{rt3}
\alias{rt3-package}
\title{rt3: A Package for Playing Tic-Tac-Toe in R.}
\description{
The rt3 package provides functions to allow a user to simulate
tic-tac-toe games. It provides a convenient \link[rt3]{gameState} object as
well as simple interface for developing new types of players.
}
\section{Main Function}{

\link[rt3]{playGame} Play a game of tic-tac-toe.
}

\section{Structures}{

\link[rt3]{gameState} A tic-tac-toe game state.
}

\section{Constants}{

\link[rt3]{X} The X player.

\link[rt3]{O} The O player.

\link[rt3]{EMPTY} The EMPTY constant. Used to indicate an empty board position.

\link[rt3]{NONE} The NONE constant. Used to indicate a draw.
}

\section{Support Functions}{

These functions are used by the \link[rt3]{playGame} function.The will also be usefull
in building game decsion trees for more complex players.

\link[rt3]{startGame} Create a new tic-tac-toe game state.

\link[rt3]{getMoves} Get the current set of valid moves for a given game state

\link[rt3]{makeMove} Apply a move to the given game state and return the resulting game state
}

\section{Built-In Player Functions}{

\link[rt3]{randomMovePlayer} A player that plays random valid moves

\link[rt3]{firstAvailableMovePlayer} A player that always plays the first move available
}
\references{
\url{https://en.wikipedia.org/wiki/Tic-tac-toe}
}

