% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assets-funs.R
\name{assets_functions}
\alias{assets_functions}
\alias{assets_download}
\alias{assets_download.doc_item}
\alias{assets_download.doc_items}
\alias{assets_download.default}
\alias{assets_url}
\alias{assets_url.doc_item}
\alias{assets_url.doc_items}
\alias{assets_url.default}
\alias{assets_select}
\alias{assets_select.doc_item}
\alias{assets_select.doc_items}
\alias{assets_select.default}
\alias{assets_rename}
\alias{assets_rename.doc_item}
\alias{assets_rename.doc_items}
\alias{assets_rename.default}
\alias{has_assets}
\alias{has_assets.doc_item}
\alias{has_assets.doc_items}
\alias{has_assets.default}
\alias{asset_key}
\alias{asset_eo_bands}
\alias{asset_raster_bands}
\title{Assets functions}
\usage{
assets_download(
  items,
  asset_names = NULL,
  output_dir = getwd(),
  overwrite = FALSE,
  ...,
  use_gdal = FALSE,
  download_fn = NULL
)

\method{assets_download}{doc_item}(
  items,
  asset_names = NULL,
  output_dir = getwd(),
  overwrite = FALSE,
  ...,
  use_gdal = FALSE,
  create_json = FALSE,
  download_fn = NULL
)

\method{assets_download}{doc_items}(
  items,
  asset_names = NULL,
  output_dir = getwd(),
  overwrite = FALSE,
  ...,
  use_gdal = FALSE,
  download_fn = NULL,
  create_json = TRUE,
  items_max = Inf,
  progress = TRUE
)

\method{assets_download}{default}(
  items,
  asset_names = NULL,
  output_dir = getwd(),
  overwrite = FALSE,
  ...,
  use_gdal = FALSE,
  create_json = FALSE,
  download_fn = NULL
)

assets_url(items, asset_names = NULL, append_gdalvsi = FALSE)

\method{assets_url}{doc_item}(items, asset_names = NULL, append_gdalvsi = FALSE)

\method{assets_url}{doc_items}(items, asset_names = NULL, append_gdalvsi = FALSE)

\method{assets_url}{default}(items, asset_names = NULL, append_gdalvsi = FALSE)

assets_select(items, ..., asset_names = NULL, select_fn = NULL)

\method{assets_select}{doc_item}(items, ..., asset_names = NULL, select_fn = NULL)

\method{assets_select}{doc_items}(items, ..., asset_names = NULL, select_fn = NULL)

\method{assets_select}{default}(items, ..., asset_names = NULL, select_fn = NULL)

assets_rename(items, mapper = NULL, ...)

\method{assets_rename}{doc_item}(items, mapper = NULL, ...)

\method{assets_rename}{doc_items}(items, mapper = NULL, ...)

\method{assets_rename}{default}(items, mapper = NULL, ...)

has_assets(items)

\method{has_assets}{doc_item}(items)

\method{has_assets}{doc_items}(items)

\method{has_assets}{default}(items)

asset_key()

asset_eo_bands(field)

asset_raster_bands(field)
}
\arguments{
\item{items}{a \code{doc_item} or \code{doc_items} object
representing the result of \verb{/stac/search},
\code{/collections/{collectionId}/items} or
\code{/collections/{collectionId}/items/{itemId}} endpoints.}

\item{asset_names}{a \code{character} vector with the names of the assets
to be selected.}

\item{output_dir}{a \code{character} directory in which the assets will be
saved. Default is the working directory (\code{getwd()})}

\item{overwrite}{a \code{logical} if TRUE will replace the existing file,
if FALSE, a warning message is shown.}

\item{...}{additional arguments. See details.}

\item{use_gdal}{a \code{logical} indicating if the file should be downloaded
by GDAL instead httr package.}

\item{download_fn}{a \code{function} to handle download of assets for
each item to be downloaded. Using this function, you can change the
hrefs for each asset, as well as the way download is done.}

\item{create_json}{a \code{logical} indicating if a JSON file with item
metadata (\code{doc_item} or \code{doc_items}) must be created in the
output directory.}

\item{items_max}{a \code{numeric} corresponding to how many items will be
downloaded.}

\item{progress}{a \code{logical} indicating if a progress bar must be
shown or not. Defaults to \code{TRUE}.}

\item{append_gdalvsi}{a \code{logical} value. If true, gdal drivers are
included in the URL of each asset. The following schemes are supported:
HTTP/HTTPS files, S3 (AWS S3) and GS (Google Cloud Storage).}

\item{select_fn}{a \code{function} to select assets an item
(\code{doc_item} or \code{doc_items}). This function receives as parameter
the asset element and, optionally, the asset name. Asset elements
contain metadata describing spatial-temporal objects. Users can provide
a function to select assets based on this metadata by returning a
logical value where \code{TRUE} selects the asset, and \code{FALSE} discards it.}

\item{mapper}{either a named \code{list} or a \code{function} to rename assets
of an item (\code{doc_item} or \code{doc_items}). In the case of a named
list, use \verb{<old name> = <new name>} to rename the assets. The function
can be used to rename the assets by returning a \code{character} string using
the metadata contained in the asset object.}

\item{field}{a \code{character} with the name of the asset field to
return.}
}
\value{
\itemize{
\item \code{assets_download()}: returns the same input object item
(\code{doc_item} or \code{doc_items}) where \code{href} properties point to
the download assets.

\item \code{assets_url()}: returns a character vector with all assets \code{href}
of an item (\code{doc_item} or \code{doc_items}).

\item \code{assets_select()}: returns the same input object item
(\code{doc_item} or \code{doc_items}) with the selected assets.

\item \code{assets_rename()}: returns the same input object item
(\code{doc_items} or \code{doc_item}) with the assets renamed.
}
}
\description{
These functions provide support to work with \code{doc_items} and
\code{doc_item} item objects.

\itemize{
\item \code{assets_download()}: Downloads the assets provided by the STAC API.

\item \code{assets_url()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Returns a
character vector with each asset href. For the URL, you can add the
GDAL library drivers for the following schemes: HTTP/HTTPS files,
S3 (AWS S3) and GS (Google Cloud Storage).

\item \code{assets_select()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Selects the
assets of each item by its name (\code{asset_names} parameter), by expressions
(\code{...} parameter), or by a selection function (\code{select_fn} parameter).
Note: This function can produce items with empty assets. In this case,
users can use the \code{items_compact()} function to remove items with no
assets.

\item \code{assets_rename()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Rename each
asset using a named list or a function.
}
}
\details{
Ellipsis argument (\code{...}) appears in different assets functions and
has distinct purposes:
\itemize{
\item \code{assets_download()}: ellipsis is used to pass
additional \code{httr} options to \link[httr:GET]{GET} or \link[httr:POST]{POST}
methods, such as \link[httr:add_headers]{add_headers} or
\link[httr:set_cookies]{set_cookies}.

\item \code{assets_select()}: ellipsis is used to pass expressions that will
be evaluated against each asset metadata. Expressions must be evaluated as
a logical value where \code{TRUE} selects the asset and \code{FALSE} discards it.
Multiple expressions are combine with \code{AND} operator. Expressions can
use \code{asset} helper functions (i.e. \code{asset_key()}, \code{asset_eo_bands()},
and \code{asset_raster_bands()}). Multiple expressions are combined with
\code{AND} operator. \code{assets_select()} uses non-standard evaluation to evaluate
its expressions. That means users must escape any variable or call to
be able to use them in the expressions. The escape is done by using
\code{double-curly-braces}, i.e., \code{{{variable}}}.

\strong{WARNING:} Errors in the evaluation of expressions are
considered as \code{FALSE}.

\item \code{assets_rename()}: ellipsis is used to pass named parameters
to be processed in the same way as the named list in \code{mapper} argument.
}
}
\examples{
\dontrun{
 # assets_download function
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
   stac_search(collections = "CB4-16D-2",
               datetime = "2019-06-01/2019-08-01") \%>\%
   stac_search() \%>\%
   get_request() \%>\%
   assets_download(asset_names = "thumbnail", output_dir = tempdir())
}

\dontrun{
 # assets_url function
 stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4-16D-2", limit = 100,
         datetime = "2017-08-01/2018-03-01",
         bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
  get_request() \%>\% items_fetch(progress = FALSE)

 stac_item \%>\% assets_url()
}

\dontrun{
 # assets_select function
 stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4-16D-2", limit = 100,
         datetime = "2017-08-01/2018-03-01",
         bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
  get_request() \%>\% items_fetch(progress = FALSE)

 stac_item \%>\% assets_select(asset_names = "NDVI")
}

\dontrun{
items <- stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
  stac_search(collections = c("landsat-8-c2-l2", "sentinel-2-l2a"),
              bbox = c(xmin = -64.85976089, ymin = -10.49199395,
                       xmax = -64.79272527, ymax =-10.44736091),
              datetime = "2019-01-01/2019-06-28",
              limit = 50) \%>\%
  post_request()

# Selects assets by name
items <- assets_select(items,
                       asset_names = c("B02", "B03", "SR_B1", "SR_B2"))
# Renames the landsat assets
items <- assets_rename(items,
                       SR_B1 = "blue",
                       SR_B2 = "green",
                       B02   = "blue",
                       B03   = "green")
# Get the assets url's
assets_url(items)
}

}
\seealso{
\code{\link[=stac_search]{stac_search()}}, \code{\link[=items]{items()}}, \code{\link[=get_request]{get_request()}}
}
