% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_param.R
\name{map_param}
\alias{map_param}
\title{Map Parameters within \code{query_fb_marketing_api()}
Groups input into a \code{map_param} object. When a \code{map_param} object is entered as a parameter in \code{query_fb_marketing_api()}, \code{query_fb_marketing_api()} makes a separate API query for each item within \code{map_param}. A \code{map_param} object is structured as a list, where the \code{map_param} class triggers the \code{query_fb_marketing_api} function to make a separate API query for each item in the list.}
\usage{
map_param(...)
}
\arguments{
\item{...}{Vector or list}
}
\value{
Object of class \code{map_param} to be used as input to the \code{query_fb_marketing_api()} function to make multiple API queries.
}
\description{
Map Parameters within \code{query_fb_marketing_api()}
Groups input into a \code{map_param} object. When a \code{map_param} object is entered as a parameter in \code{query_fb_marketing_api()}, \code{query_fb_marketing_api()} makes a separate API query for each item within \code{map_param}. A \code{map_param} object is structured as a list, where the \code{map_param} class triggers the \code{query_fb_marketing_api} function to make a separate API query for each item in the list.
}
\examples{
\dontrun{
# Make 3 queries:
# 1. Number of males and females MAU/DAU
# 2. Number of male MAU/DAU
# 3. Number of female MAU/DAU
query_fb_marketing_api(
  location_unit_type = "countries",
  location_keys      = "US",
  gender             = map_param(c(1,2), 1, 2),
  version            = VERSION, 
  creation_act       = CREATION_ACT, 
  token              = TOKEN)
}
}
