library(rslp)
context("rslp_doc")
steprules <- readRDS(system.file("steprules.rds", package = "rslp"))

test_that("rslp_doc works fine", {
  expect_equal(rslp::rslp_doc("bons"), "bom")
  expect_equal(rslp::rslp_doc("bal\u00f5es"), "bal")
  expect_equal(rslp::rslp_doc("capit\u00e3es"), "capita")
  expect_equal(rslp::rslp_doc("normais"), "norm")
  expect_equal(rslp::rslp_doc("am\u00e1veis"), "am")
  expect_equal(rslp::rslp_doc("len\u00e7\u00f3is"), "lencol")
  expect_equal(rslp::rslp_doc("barris"), "barril")
  expect_equal(rslp::rslp_doc("males"), "mal")
  expect_equal(rslp::rslp_doc("mares"), "mar")
  expect_equal(rslp::rslp_doc("casas"), "cas")
  expect_equal(rslp::rslp_doc("chefona"), "chef")
  expect_equal(rslp::rslp_doc("vil\u00e3"), "vila")
  expect_equal(rslp::rslp_doc("professora"), "profes")
  expect_equal(rslp::rslp_doc("americana"), "americ")
  expect_equal(rslp::rslp_doc("chilena"), "chilen")
  expect_equal(rslp::rslp_doc("inglesa"), "ingl")
  expect_equal(rslp::rslp_doc("famosa"), "fam")
  expect_equal(rslp::rslp_doc("man\u00edaca"), "man")
  expect_equal(rslp::rslp_doc("pr\u00e1tica"), "prat")
  expect_equal(rslp::rslp_doc("mantida"), "mant")
  expect_equal(rslp::rslp_doc("cansada"), "cans")
  expect_equal(rslp::rslp_doc("prima"), "prim")
  expect_equal(rslp::rslp_doc("passiva"), "passiv")
  expect_equal(rslp::rslp_doc("primeira"), "prim")
  expect_equal(rslp::rslp_doc("sozinha"), "so")
  expect_equal(rslp::rslp_doc("felizmente"), "feliz")
  expect_equal(rslp::rslp_doc("cansad\u00edssimo"), "cans")
  # expect_equal(rslp::rslp_doc("amabil\u00edssimo"), "ama")
  expect_equal(rslp::rslp_doc("fort\u00edssimo"), "fort")
  expect_equal(rslp::rslp_doc("chiqu\u00e9rrimo"), "chiqu")
  expect_equal(rslp::rslp_doc("pezinho"), "pe")
  expect_equal(rslp::rslp_doc("maluquinho"), "maluc")
  expect_equal(rslp::rslp_doc("amiguinho"), "amig")
  expect_equal(rslp::rslp_doc("cansadinho"), "cans")
  expect_equal(rslp::rslp_doc("carrinho"), "carr")
  expect_equal(rslp::rslp_doc("grandalh\u00e3o"), "grand")
  #expect_equal(rslp::rslp_doc("dentu\u00e7a"), "dent") # ver pq não funciona
  expect_equal(rslp::rslp_doc("mulhera\u00e7o"), "mulh")
  expect_equal(rslp::rslp_doc("cansad\u00e3o"), "cans")
  expect_equal(rslp::rslp_doc("corp\u00e1zio"), "corp")
  expect_equal(rslp::rslp_doc("pratarraz"), "prat")
  #expect_equal(rslp::rslp_doc("bocarra"), "boc") # ver pq não funciona
  expect_equal(rslp::rslp_doc("calorz\u00e3o"), "cal")
  expect_equal(rslp::rslp_doc("menin\u00e3o"), "menin")
  expect_equal(rslp::rslp_doc("existencialista"), "exist")
  expect_equal(rslp::rslp_doc("minimalista"), "minim")
  expect_equal(rslp::rslp_doc("contagem"), "cont")
  expect_equal(rslp::rslp_doc("gerenciamento"), "gerenc")
  expect_equal(rslp::rslp_doc("monitoramento"), "monitor") # diferente do artigo que est\u00e1 errado
  expect_equal(rslp::rslp_doc("nascimento"), "nasc")
  expect_equal(rslp::rslp_doc("comercializado"), "comerci")
  expect_equal(rslp::rslp_doc("traumatizado"), "traum")
  expect_equal(rslp::rslp_doc("alfabetizado"), "alfabet")
  expect_equal(rslp::rslp_doc("associativo"), "associ")
  expect_equal(rslp::rslp_doc("contraceptivo"), "contracep")
  expect_equal(rslp::rslp_doc("esportivo"), "espor") # diferente do artigo. o artigo est\u00e1 errado
  expect_equal(rslp::rslp_doc("abalado"), "abal")
  expect_equal(rslp::rslp_doc("impedido"), "imped")
  expect_equal(rslp::rslp_doc("ralador"), "ral")
  expect_equal(rslp::rslp_doc("entendido"), "entend")
  expect_equal(rslp::rslp_doc("cumpridor"), "cumpr")
  expect_equal(rslp::rslp_doc("obrigat\u00f3ria"), "obrig")
  expect_equal(rslp::rslp_doc("produtor"), "produt")
  expect_equal(rslp::rslp_doc("comparabilidade"), "compar")
  expect_equal(rslp::rslp_doc("abolicionista"), "abol")
  expect_equal(rslp::rslp_doc("intervencionista"), "interven")
  expect_equal(rslp::rslp_doc("profissional"), "profiss")
  expect_equal(rslp::rslp_doc("refer\u00eancia"), "refer")
  expect_equal(rslp::rslp_doc("repugn\u00e2ncia"), "repugn")
  expect_equal(rslp::rslp_doc("abatedouro"), "abat")
  expect_equal(rslp::rslp_doc("fofoqueiro"), "fofoc")
  expect_equal(rslp::rslp_doc("brasileiro"), "brasil")
  expect_equal(rslp::rslp_doc("gostoso"), "gost")
  expect_equal(rslp::rslp_doc("comercializa\u00e7"), "comerci")
  expect_equal(rslp::rslp_doc("consumismo"), "consum")
  expect_equal(rslp::rslp_doc("concretiza\u00e7\u00e3o"), "concre")
  expect_equal(rslp::rslp_doc("alega\u00e7"), "aleg")
  expect_equal(rslp::rslp_doc("aboli\u00e7"), "abol")
  expect_equal(rslp::rslp_doc("anedot\u00e1rio"), "anedot")
  expect_equal(rslp::rslp_doc("minist\u00e9rio"), "minist")
  expect_equal(rslp::rslp_doc("chin\u00eas"), "chin")
  expect_equal(rslp::rslp_doc("beleza"), "bel")
  expect_equal(rslp::rslp_doc("rigidez"), "rigid")
  expect_equal(rslp::rslp_doc("parentesco"), "parent")
  expect_equal(rslp::rslp_doc("ocupante"), "ocup")
  expect_equal(rslp::rslp_doc("bomb\u00e1stico"), "bomb")
  expect_equal(rslp::rslp_doc("problem\u00e1tico"), "problem")
  expect_equal(rslp::rslp_doc("pol\u00eamico"), "polem")
  expect_equal(rslp::rslp_doc("produtividade"), "produt")
  expect_equal(rslp::rslp_doc("profundidade"), "profund")
  expect_equal(rslp::rslp_doc("aposentadoria"), "aposentad")
  expect_equal(rslp::rslp_doc("anedot\u00e1rio"), "anedot")
  expect_equal(rslp::rslp_doc("existencial"), "exist")
  expect_equal(rslp::rslp_doc("artista"), "artist") #
  expect_equal(rslp::rslp_doc("maluquice"), "maluc")
  expect_equal(rslp::rslp_doc("chatice"), "chat")
  expect_equal(rslp::rslp_doc("demon\u00edaco"), "demon")
  expect_equal(rslp::rslp_doc("decorrente"), "decorr")
  expect_equal(rslp::rslp_doc("criminal"), "crim")
  expect_equal(rslp::rslp_doc("americano"), "americ")
  expect_equal(rslp::rslp_doc("am\u00e1vel"), "am")
  expect_equal(rslp::rslp_doc("combust\u00edvel"), "combust")
  expect_equal(rslp::rslp_doc("cobertura"), "cobert")
  expect_equal(rslp::rslp_doc("consensual"), "consens")
  expect_equal(rslp::rslp_doc("mundial"), "mund")
  expect_equal(rslp::rslp_doc("experimental"), "experiment")
  expect_equal(rslp::rslp_doc("cantar\u00edamo"), "cant")
  expect_equal(rslp::rslp_doc("cant\u00e1ssemo"), "cant")
  expect_equal(rslp::rslp_doc("beber\u00edamo"), "beb")
  expect_equal(rslp::rslp_doc("beb\u00eassemo"), "beb")
  expect_equal(rslp::rslp_doc("partir\u00edamo"), "part")
  expect_equal(rslp::rslp_doc("part\u00edssemo"), "part")
  expect_equal(rslp::rslp_doc("cant\u00e1ramo"), "cant")
  expect_equal(rslp::rslp_doc("cant\u00e1rei"), "cant")
  expect_equal(rslp::rslp_doc("cantaremo"), "cant")
  expect_equal(rslp::rslp_doc("cantariam"), "cant")
  expect_equal(rslp::rslp_doc("cantar\u00edei"), "cant")
  expect_equal(rslp::rslp_doc("cant\u00e1ssei"), "cant")
  expect_equal(rslp::rslp_doc("cantassem"), "cant")
  expect_equal(rslp::rslp_doc("cant\u00e1vamo"), "cant")
  expect_equal(rslp::rslp_doc("beb\u00earamo"), "beb")
  expect_equal(rslp::rslp_doc("beberemo"), "beb")
  expect_equal(rslp::rslp_doc("beberiam"), "beb")
  expect_equal(rslp::rslp_doc("beber\u00edei"), "beb")
  expect_equal(rslp::rslp_doc("beb\u00eassei"), "beb")
  expect_equal(rslp::rslp_doc("bebessem"), "beb")
  expect_equal(rslp::rslp_doc("partir\u00edamo"), "part")
  expect_equal(rslp::rslp_doc("partiremo"), "part")
  expect_equal(rslp::rslp_doc("partiriam"), "part")
  expect_equal(rslp::rslp_doc("partir\u00edei"), "part")
  expect_equal(rslp::rslp_doc("part\u00edssei"), "part")
  expect_equal(rslp::rslp_doc("partissem"), "part")
  expect_equal(rslp::rslp_doc("cantando"), "cant")
  expect_equal(rslp::rslp_doc("bebendo"), "beb")
  expect_equal(rslp::rslp_doc("partindo"), "part")
  expect_equal(rslp::rslp_doc("propondo"), "prop")
  expect_equal(rslp::rslp_doc("cantaram"), "cant")
  expect_equal(rslp::rslp_doc("cantarde"), "cant")
  expect_equal(rslp::rslp_doc("cantarei"), "cant")
  expect_equal(rslp::rslp_doc("cantarem"), "cant")
  expect_equal(rslp::rslp_doc("cantaria"), "cant")
  expect_equal(rslp::rslp_doc("cantarmo"), "cant")
  expect_equal(rslp::rslp_doc("cantasse"), "cant")
  expect_equal(rslp::rslp_doc("cantaste"), "cant")
  expect_equal(rslp::rslp_doc("cantavam"), "cant")
  expect_equal(rslp::rslp_doc("cant\u00e1vei"), "cant")
  expect_equal(rslp::rslp_doc("beberam"), "beb")
  expect_equal(rslp::rslp_doc("beberde"), "beb")
  expect_equal(rslp::rslp_doc("beberei"), "beb")
  expect_equal(rslp::rslp_doc("beb\u00earei"), "beb")
  expect_equal(rslp::rslp_doc("beberem"), "beb")
  expect_equal(rslp::rslp_doc("beberia"), "beb")
  expect_equal(rslp::rslp_doc("bebermo"), "beb")
  expect_equal(rslp::rslp_doc("bebesse"), "beb")
  expect_equal(rslp::rslp_doc("bebeste"), "beb")
  expect_equal(rslp::rslp_doc("beb\u00edamo"), "beb")
  expect_equal(rslp::rslp_doc("partiram"), "part")
  expect_equal(rslp::rslp_doc("conclu\u00edram"), "conclu")
  expect_equal(rslp::rslp_doc("partirde"), "part")
  expect_equal(rslp::rslp_doc("partirei"), "part")
  expect_equal(rslp::rslp_doc("partirem"), "part")
  expect_equal(rslp::rslp_doc("partiria"), "part")
  expect_equal(rslp::rslp_doc("partirmo"), "part")
  expect_equal(rslp::rslp_doc("partisse"), "part")
  expect_equal(rslp::rslp_doc("partiste"), "part")
  expect_equal(rslp::rslp_doc("cantamo"), "cant")
  expect_equal(rslp::rslp_doc("cantara"), "cant")
  expect_equal(rslp::rslp_doc("cantar\u00e1"), "cant")
  expect_equal(rslp::rslp_doc("cantare"), "cant")
  expect_equal(rslp::rslp_doc("cantava"), "cant")
  expect_equal(rslp::rslp_doc("cantemo"), "cant")
  expect_equal(rslp::rslp_doc("bebera"), "beb")
  expect_equal(rslp::rslp_doc("beber\u00e1"), "beb")
  expect_equal(rslp::rslp_doc("bebere"), "beb")
  expect_equal(rslp::rslp_doc("bebiam"), "beb")
  expect_equal(rslp::rslp_doc("beb\u00edei"), "beb")
  expect_equal(rslp::rslp_doc("partimo"), "part")
  expect_equal(rslp::rslp_doc("partira"), "part")
  expect_equal(rslp::rslp_doc("partir\u00e1"), "part")
  expect_equal(rslp::rslp_doc("partire"), "part")
  expect_equal(rslp::rslp_doc("compomo"), "comp")
  expect_equal(rslp::rslp_doc("cantai"), "cant")
  expect_equal(rslp::rslp_doc("cantam"), "cant")
  expect_equal(rslp::rslp_doc("cheguei"), "cheg")
  expect_equal(rslp::rslp_doc("cantei"), "cant")
  expect_equal(rslp::rslp_doc("cantem"), "cant")
  expect_equal(rslp::rslp_doc("beber"), "beb")
  expect_equal(rslp::rslp_doc("bebeu"), "beb")
  expect_equal(rslp::rslp_doc("bebia"), "beb")
  expect_equal(rslp::rslp_doc("partir"), "part")
  expect_equal(rslp::rslp_doc("partiu"), "part")
  expect_equal(rslp::rslp_doc("chegou"), "cheg")
  expect_equal(rslp::rslp_doc("bebi"), "beb")
  expect_equal(rslp::rslp_doc("menina"), "menin")
  expect_equal(rslp::rslp_doc("grande"), "grand")
  expect_equal(rslp::rslp_doc("menino"), "menin")
})
