% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminateApp.R
\name{terminateApp}
\alias{terminateApp}
\title{Terminate an Application}
\usage{
terminateApp(appName, account = NULL, server = NULL, quiet = FALSE)
}
\arguments{
\item{appName}{Name of application to terminate}

\item{account}{Account name. If a single account is registered on the system
then this parameter can be omitted.}

\item{server}{Server name. Required only if you use the same account name on
multiple servers (see \code{\link[=servers]{servers()}})}

\item{quiet}{Request that no status information be printed to the console
during the termination.}
}
\description{
Terminate and archive a currently deployed ShinyApps application.
}
\note{
This function only works for ShinyApps servers.
}
\examples{
\dontrun{

# terminate an application
terminateApp("myapp")
}
}
\seealso{
\code{\link[=applications]{applications()}}, \code{\link[=deployApp]{deployApp()}}, and
\code{\link[=restartApp]{restartApp()}}
}
