% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrrr.R
\name{mrrr}
\alias{mrrr}
\title{Generalized or mixed-response reduced-rank regression}
\usage{
mrrr(
  Y,
  X,
  is.pca = NULL,
  offset = NULL,
  ctrl.id = c(),
  family = list(gaussian(), binomial()),
  familygroup = NULL,
  maxrank = min(ncol(Y), ncol(X)),
  penstr = list(),
  init = list(),
  control = list()
)
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{is.pca}{If TRUE, mixed principal component analysis with X=I}

\item{offset}{matrix of the same dimension as Y for offset}

\item{ctrl.id}{indices of unpenalized predictors}

\item{family}{a list of family functions as used in \code{glm}}

\item{familygroup}{a list of family indices of the responses}

\item{maxrank}{integer giving the maximum rank allowed. Usually this can be
set to min(n,p,q)}

\item{penstr}{a list of penalty structure of SVD, contains penstr$penaltySVD
is the penalty of SVD, penstr$lambdaSVD is the regularization parameter}

\item{init}{a list of initial values of kappaC0, kappaS0, C0, and S0}

\item{control}{a list of controling parameters for the fitting}
}
\value{
S3 \code{mrrr} object, a list containing
\item{obj}{the objective function tracking}
\item{converged}{TRUE/FALSE for convergence}
\item{coef}{the estimated coefficient matrix}
\item{outlier}{the estimated outlier matrix}
\item{nrank}{the rank of the fitted model}
}
\description{
Peforms either rank constrained maximum likelihood estimation or
singular value penalized estimation.
}
\details{
The model fitting process can be fine tuned through argument \code{control}.
The available elements for \code{control} include
\itemize{
   \item{epsilon}: positive convergence tolerance epsilon; the
       iterations converge when |new - old | / (old + 0.1) < epsilon.
       treated as zero.
   \item{sv.tol}: tolerance for singular values.
   \item{maxit}: integer giving the maximal number of iterations.
   \item{trace:}{logical indicating if tracing the objective is needed.}
   \item{conv.obj:}{if TRUE, track objective function.}
   \item{equal.phi:}{if TRUE, use a single dispersion parameter for Gaussian
       responses.}
   \item{plot.obj:}{if TRUE, plot obj values along iterations; for checking
       only}
   \item{plot.cv:}{if TRUE, plot cross validation error.}
   \item{gammaC0:}{adaptive scaling to speed up computation.}
}
Similarly, the available elements for arguments \code{penstr} specifying
penalty structure of SVD include
\itemize{
   \item{penaltySVD}: penalty for reducing rank
   \item{lambdaSVD}: tuning parameter. For penaltySVD = rankCon, this is the
    specified rank.
}
}
\examples{
library(rrpack)
simdata <- rrr.sim3(n = 100, p = 30, q.mix = c(5, 20, 5),
                    nrank = 2, mis.prop = 0.2)
Y <- simdata$Y
Y_mis <- simdata$Y.mis
X <- simdata$X
X0 <- cbind(1, X)
C <- simdata$C
family <- simdata$family
familygroup <- simdata$familygroup
svdX0d1 <- svd(X0)$d[1]
init1 = list(kappaC0 = svdX0d1 * 5)
offset = NULL
control = list(epsilon = 1e-4, sv.tol = 1e-2, maxit = 2000,
               trace = FALSE, gammaC0 = 1.1, plot.cv = TRUE,
               conv.obj = TRUE)
fit.mrrr <- mrrr(Y_mis, X, family = family, familygroup = familygroup,
                 penstr = list(penaltySVD = "rankCon", lambdaSVD = 2),
                 control = control, init = init1)
summary(fit.mrrr)
coef(fit.mrrr)
par(mfrow = c(1, 2))
plot(fit.mrrr$obj)
plot(C ~ fit.mrrr$coef[- 1 ,])
abline(a = 0, b = 1)
}
