% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Opal.R
\name{updateCourseElementResource,Opal-method}
\alias{updateCourseElementResource,Opal-method}
\title{Update the referenced learning resource of a course element in the LMS Opal}
\usage{
\S4method{updateCourseElementResource}{Opal}(
  object,
  course_id,
  node_id,
  resource_id,
  publish = TRUE
)
}
\arguments{
\item{object}{An S4 object of class \link{LMS} that represents a connection to the
LMS.}

\item{course_id}{A character string with the course ID. You can find this in
the course's details (Resource ID) in the LMS.}

\item{node_id}{A character string with the course element ID. This can be
found, for example, in the course editor under the "Title and Description"
tab of the respective course element in the LMS Opal.}

\item{resource_id}{A character string wiht the ID of the resource. This can
be found in the details view of the desired resource within the LMS.}

\item{publish}{A boolean value that determines whether the course should be
published after the resource is updated. If \code{TRUE} (default), the course
will be published immediately after the update. If \code{FALSE}, the course will
not be published automatically, leaving it in an unpublished state until
manual publication.}
}
\value{
The response of the HTTP request made to update the resource. If the
course is published, an additional message about the publishing status is
returned.
}
\description{
Update the referenced learning resource of a course element in the LMS Opal
}
