% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design.R
\name{TrialDesignGroupSequential}
\alias{TrialDesignGroupSequential}
\title{Group Sequential Design}
\description{
Trial design for group sequential design.
}
\details{
This object should not be created directly;
use \code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}}
with suitable arguments to create a group sequential design.
}
\section{Fields}{

\describe{
\item{\code{kMax}}{The maximum number of stages \code{K}. Is a numeric vector of length 1 containing a whole number.}

\item{\code{alpha}}{The significance level alpha, default is 0.025. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{stages}}{The stage numbers of the trial. Is a numeric vector of length \code{kMax} containing whole numbers.}

\item{\code{informationRates}}{The information rates (that must be fixed prior to the trial), default is \code{(1:kMax) / kMax}. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{userAlphaSpending}}{The user defined alpha spending. Contains the cumulative alpha-spending (type I error rate) up to each interim stage. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{criticalValues}}{The critical values for each stage of the trial. Is a numeric vector of length \code{kMax}.}

\item{\code{stageLevels}}{The adjusted significance levels to reach significance in a group sequential design. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{alphaSpent}}{The cumulative alpha spent at each stage. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{bindingFutility}}{If \code{TRUE}, the calculation of the critical values is affected by the futility bounds and the futility threshold is binding in the sense that the study must be stopped if the futility condition was reached (default is \code{FALSE}) Is a logical vector of length 1.}

\item{\code{tolerance}}{The numerical tolerance, default is \code{1e-06}. Is a numeric vector of length 1.}

\item{\code{typeOfDesign}}{The type of design. Is a character vector of length 1.}

\item{\code{beta}}{The Type II error rate necessary for providing sample size calculations  (e.g., in \code{getSampleSizeMeans}), beta spending function designs, or optimum designs, default is \code{0.20}. Is a numeric vector of length 1 containing a value between 0 and 1.}

\item{\code{deltaWT}}{Delta for Wang & Tsiatis Delta class. Is a numeric vector of length 1.}

\item{\code{deltaPT1}}{Delta1 for Pampallona & Tsiatis class rejecting H0 boundaries. Is a numeric vector of length 1.}

\item{\code{deltaPT0}}{Delta0 for Pampallona & Tsiatis class rejecting H1 (accepting H0) boundaries. Is a numeric vector of length 1.}

\item{\code{futilityBounds}}{The futility bounds for each stage of the trial. Is a numeric vector of length \code{kMax}.}

\item{\code{gammaA}}{The parameter for the alpha spending function. Is a numeric vector of length 1.}

\item{\code{gammaB}}{The parameter for the beta spending function. Is a numeric vector of length 1.}

\item{\code{optimizationCriterion}}{The optimization criterion for optimum design within the Wang & Tsiatis class (\code{"ASNH1"}, \code{"ASNIFH1"}, \code{"ASNsum"}), default is \code{"ASNH1"}.}

\item{\code{sided}}{Describes if the alternative is one-sided (\code{1}) or two-sided (\code{2}). Is a numeric vector of length 1 containing a whole number.}

\item{\code{betaSpent}}{The cumulative beta level spent at each stage of the trial. Only applicable for beta-spending designs. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{typeBetaSpending}}{The type of beta spending. Is a character vector of length 1.}

\item{\code{userBetaSpending}}{The user defined beta spending. Contains the cumulative beta-spending up to each interim stage. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{efficacyStops}}{Logical vector indicating efficacy stops Is a logical vector of length \code{kMax} minus 1.}

\item{\code{futilityStops}}{Logical vector indicating futility stops Is a logical vector of length \code{kMax} minus 1.}

\item{\code{power}}{The one-sided power at each stage of the trial. Is a numeric vector of length \code{kMax} containing values between 0 and 1.}

\item{\code{twoSidedPower}}{Specifies if power is defined two-sided at each stage of the trial. Is a logical vector of length 1.}

\item{\code{constantBoundsHP}}{The constant bounds up to stage kMax - 1 for the Haybittle & Peto design (default is 3). Is a numeric vector of length 1.}

\item{\code{betaAdjustment}}{If \code{TRUE}, beta spending values are linearly adjusted if an overlapping of decision regions for futility stopping at earlier stages occurs. Only applicable for two-sided beta-spending designs. Is a logical vector of length 1.}

\item{\code{delayedInformation}}{Delay of information for delayed response designs. Is a numeric vector of length \code{kMax} minus 1 containing values between 0 and 1.}

\item{\code{decisionCriticalValues}}{The decision critical values for each stage of the trial in a delayed response design. Is a numeric vector of length \code{kMax}.}

\item{\code{reversalProbabilities}}{The probability to switch from stopping the trial for success (or futility) and reaching non-rejection (or rejection) in a delayed response design. Is a numeric vector of length \code{kMax} minus 1 containing values between 0 and 1.}
}}

\seealso{
\code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}} for creating a group sequential design.
}
\keyword{internal}
