% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rope.R
\name{rope}
\alias{rope}
\title{FDR controlled model selection}
\usage{
rope(data, B, fdr = 0.1, mc.cores = getOption("mc.cores", 2L),
  only.first = FALSE)
}
\arguments{
\item{data}{Matrix of variable presence counts. One column for each variable,
one row for each parameter value (e.g. levels of regularization).}

\item{B}{Number of bootstraps used to construct \code{data}. At least 21 are
needed for u-shape test heuristic to work, but in general it is recommended
to use many more.}

\item{fdr}{Vector of target false discovery rates to return selections for}

\item{mc.cores}{Number of threads to run in parallel (1 turns of
parallelization)}

\item{only.first}{Skip second part of algorithm. Saves time but gives worse
results.}
}
\value{
A list with components
  \item{selection}{matrix (one row for each fdr target, one column for
    each variable)}
  \item{q}{vector of q-values, one for each variable}
  \item{level}{index of most separating parameter value}
  \item{alt.prop}{estimated proportion of alternative variables}
}
\description{
Estimates a model from bootstap counts. The objective is to maximize accuracy
while controlling the false discovery rate of selected variables. Developed
for high-dimensional models with number of variables in the order of at least
10000.
}
\examples{
\dontrun{
data # a matrix of selection counts, for 100 bootstraps, with ncol(data)
  # potential variables counted for nrow(data) different penalization levels
fdr <- c(0.05, 0.1)
result <- rope(data, 100, fdr)
}

}
\author{
Jonatan Kallus, \email{kallus@chalmers.se}
}
\keyword{htest}
\keyword{models}
\keyword{multivariate}
