% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolr-functions.R
\name{rmolr}
\alias{rmolr}
\title{Finding Optimal Cutpoints Using Modified Ordered Logrank (MOL) Tests}
\usage{
rmolr(times, status, x, ns = 15, alt = "decrease", method = "approximate")
}
\arguments{
\item{times}{Survival outcome.}

\item{status}{Censoring indicator which takes 1 when an event occurs at end
of study and 0 otherwise.}

\item{x}{A continuous covariate.}

\item{ns}{Minimum number of subjects in each group after dichotomizing the
covariate.}

\item{alt}{A character that takes either \code{"decrease"} or \code{"increase"}
to represent a positive or negative association between the covariate
and survival.}

\item{method}{A character that takes either \code{"approximate"} or
\code{"exact"} where an approximate or exact method will be used.}
}
\value{
Returns a list with two elements, with the first being the test
  statistics for all cutpoints considered and the second being the best
  splits from the MOL tests.
}
\description{
Using the modified ordered logrank test (MOL), the \code{rmolr}
  function finds two optimal cutpoints to divide the entire dataset into three
  groups based on a continuous covariate and a survival outcome. It is a fast
  procedure that makes use of the running logrank test (\code{\link{rlr}})
  to improve on computing speed.
}
\details{
When the true association is positive, that is, larger covariate
  values lead to worse survival, and you enter \code{alt = "decrease"}, the test
  statistics will be positive, but if you enter \code{trend = "increase"} the
  test statistics will be negative. Opposite is true when the true association
  is negative. You want to make sure to enter the option so that the
  resulting test statistics are positive.
}
\examples{
library(rolr)

##### -------- Example 1

#simulate data with true cutpoints and hazard goes up as covariate goes up
d=simdata(nn = 150, hr = c(1, 2, 3), hazard.func = "step",
          props=c(1/3, 1/3, 1/3), censoring.rate = 0)

#using alt = 'decrease', the test statistics are positive, so the results
#are correct.
res=rmolr(times=d$times, status=d$status, x=d$x, ns=15, alt='decrease')
names(res)

#do it again using alt = 'increase', now the test statistics are negative
#so the results are not right. So you have to switch back to alt='decrease'
#to get positive statistics and the correct optimal cutpoints here.
res2=rmolr(times=d$times, status=d$status, x=d$x, ns=15, alt='increase')
names(res2)

##### -------- Example 2

#Simulate data with true cutpoints and hazard goes down as covariate goes up
d=simdata(nn = 150, hr = c(3, 2, 1), hazard.func = "step",
          props=c(1/3, 1/3, 1/3), censoring.rate = 0)

#using alt = 'decrease', the test statistics are negative and so the results
#are not right.
res=rmolr(times=d$times, status=d$status, x=d$x, ns=15, alt='decrease')
res[['best.splits.molr']]

#do it again using alt = 'increase', now the test statistics are positive
#and thus the results are correct.
res2=rmolr(times=d$times, status=d$status, x=d$x, ns=15, alt='increase')
res2[['best.splits.molr']]

}
\references{
See main package help page.
}
\seealso{
\code{\link{rsolr12}}, \code{\link{rhier}}
}

