% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateRollingLDA.R
\name{updateRollingLDA}
\alias{updateRollingLDA}
\alias{RollingLDA.RollingLDA}
\title{Updating an existing RollingLDA object}
\usage{
updateRollingLDA(
  x,
  texts,
  dates,
  chunks,
  memory,
  param = getParam(x),
  compute.topics = TRUE,
  memory.fallback = 0L,
  ...
)

\method{RollingLDA}{RollingLDA}(
  x,
  texts,
  dates,
  chunks,
  memory,
  param = getParam(x),
  compute.topics = TRUE,
  memory.fallback = 0L,
  ...
)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{RollingLDA}} object.}

\item{texts}{[\code{named list}]\cr
Tokenized texts.}

\item{dates}{[\code{(un)named Date}]\cr
Sorted dates of the tokenized texts. If unnamed, it must match the order of texts.}

\item{chunks}{[\code{Date} or \code{character(1)}]\cr
Sorted dates of the beginnings of each chunk to be modeled as updates.
If passed as \code{character}, dates are determined by passing the minimum of
\code{dates} as \code{from} argument, \code{max(dates)} as \code{to} argument
and \code{chunks} as \code{by} argument in \code{\link{seq.Date}}.
If not passed, all texts are interpreted as one chunk.}

\item{memory}{[\code{Date}, \code{character(1)} or \code{integer(1)}]\cr
Dates of the beginnings of each chunk's memory. If passed as \code{character},
dates are determined by using the dates of the beginnings of each chunk and
substracting the given time interval in \code{memory} passing it as
\code{by} argument in \code{\link{seq.Date}}. If passed as
\code{integer/numeric}, the dates are determined by going backwards the
modeled texts chronologically and taking the date of the text at position
\code{memory}.}

\item{param}{[\code{named list}] with entries (Default is \code{getParam(x)})
 \describe{
  \item{\code{vocab.abs}}{[\code{integer(1)}]
  An absolute lower bound limit for which words are taken into account. All
  words are considered in the vocabularies that have a count higher than
  \code{vocab.abs} over all texts and at the same time a higher relative
  frequency than \code{vocab.rel}.}
  \item{\code{vocab.rel}}{[0,1]
  A relative lower bound limit for which words are taken into account.
  See also \code{vocab.abs}.}
  \item{\code{vocab.fallback}}{[\code{integer(1)}]
  An absolute lower bound limit for which words are taken into account. All
  words are considered in the vocabularies that have a count higher than
  \code{vocab.fallback} over all texts even if they might not have a higher
  relative frequency than \code{vocab.rel}.}
  \item{\code{doc.abs}}{[\code{integer(1)}]
  An absolute lower bound limit for which texts are taken into account. All
  texts are considered for modeling that have more words (subsetted to words
  occurring in the vocabularies) than \code{doc.abs}.}
}}

\item{compute.topics}{[\code{logical(1)}]\cr
Should the topic matrix of the LDA model be computed? Default is \code{TRUE}.}

\item{memory.fallback}{[\code{integer(1)}]\cr
If there are no texts as memory in a certain chunk, \code{memory} is
determined by going backwards the modeled texts chronologically and taking
the date of the text at position \code{memory.fallback}.
Default is 0, which means "end the fitting".}

\item{...}{not implemented}
}
\value{
[\code{named list}] with entries
 \describe{
  \item{\code{id}}{[\code{character(1)}] See above.}
  \item{\code{lda}}{\code{\link[ldaPrototype]{LDA}} object of the fitted RollingLDA.}
  \item{\code{docs}}{[\code{named list}] with modeled texts in a preprocessed format.
  See \code{\link[tosca]{LDAprep}}}
  \item{\code{dates}}{[\code{named Date}] with dates of the modeled texts.}
  \item{\code{vocab}}{[\code{character}] with the vocabularies considered
  for modeling.}
  \item{\code{chunks}}{[\code{data.table}] with specifications for each
  model chunk.}
  \item{\code{param}}{[\code{named list}] with parameter specifications for
  \code{vocab.abs} [\code{integer(1)}], \code{vocab.rel} [0,1],
  \code{vocab.fallback} [\code{integer(1)}] and
  \code{doc.abs} [\code{integer(1)}]. See above for explanation.}
}
}
\description{
Performs an update of an existing object consisting of a rolling version
of Latent Dirichlet Allocation.
}
\details{
The function uses an existing \code{\link{RollingLDA}} object and
models new texts with a specified memory as initialization of the new LDA chunk.

The function returns a \code{\link{RollingLDA}} object. You can receive results and
all other elements of this object with getter functions (see \code{\link{getChunks}}).
}
\examples{
\donttest{
roll_lda = RollingLDA(texts = economy_texts[economy_dates < "2008-05-01"],
                      dates = economy_dates[economy_dates < "2008-05-01"],
                      chunks = "month",
                      memory = "month",
                      init = 100,
                      K = 10,
                      type = "lda")

# updateRollingLDA = RollingLDA, if first argument is a RollingLDA object
roll_update = RollingLDA(roll_lda,
                         texts = economy_texts[economy_dates >= "2008-05-01"],
                         dates = economy_dates[economy_dates >= "2008-05-01"],
                         chunks = "month",
                         memory = "month")

roll_update
getChunks(roll_update)
}

}
\seealso{
Other RollingLDA functions: 
\code{\link{RollingLDA}()},
\code{\link{as.RollingLDA}()},
\code{\link{getChunks}()}
}
\concept{RollingLDA functions}
