% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{get_new_dimension_instances}
\alias{get_new_dimension_instances}
\alias{get_new_dimension_instances.star_database_update}
\title{Get new dimension instances}
\usage{
get_new_dimension_instances(sdbu)

\method{get_new_dimension_instances}{star_database_update}(sdbu)
}
\arguments{
\item{sdbu}{A \code{star_database_update} object.}
}
\value{
A list of \code{tibble} objects.
}
\description{
From the planned update, it obtains the instances of the update dimensions
that are not included in the star database dimensions to be updated.
}
\examples{

f1 <-
  flat_table('ft_num', ft_cause_rpd[ft_cause_rpd$City != 'Cambridge' &
                                      ft_cause_rpd$WEEK != '4',]) |>
  as_star_database(mrs_cause_schema_rpd) |>
  role_playing_dimension(rpd = "When",
                         roles = c("When Available", "When Received"))
f2 <- flat_table('ft_num2', ft_cause_rpd[ft_cause_rpd$City != 'Bridgeport' &
                                           ft_cause_rpd$WEEK != '2',])
f2 <- f2 |>
  update_according_to(f1)
dim_instances <- f2 |>
  get_new_dimension_instances()

}
\seealso{
\code{\link{star_database}}

Other star database refresh functions: 
\code{\link{get_existing_fact_instances}()},
\code{\link{get_lookup_tables}()},
\code{\link{get_star_database}()},
\code{\link{get_star_schema}()},
\code{\link{get_transformation_code}()},
\code{\link{get_transformation_file}()},
\code{\link{incremental_refresh}()},
\code{\link{update_according_to}()}
}
\concept{star database refresh functions}
