% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas.R
\name{dimension_schema}
\alias{dimension_schema}
\title{\code{dimension_schema} S3 class}
\usage{
dimension_schema(
  name = NULL,
  attributes = NULL,
  scd_nk = NULL,
  scd_t0 = NULL,
  scd_t1 = NULL,
  scd_t2 = NULL,
  scd_t3 = NULL,
  scd_t6 = NULL,
  is_when = FALSE,
  ...
)
}
\arguments{
\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}

\item{scd_nk}{A vector of attribute names, scd natural key.}

\item{scd_t0}{A vector of attribute names, scd T0 attributes.}

\item{scd_t1}{A vector of attribute names, scd T1 attributes.}

\item{scd_t2}{A vector of attribute names, scd T2 attributes.}

\item{scd_t3}{A vector of attribute names, scd T3 attributes.}

\item{scd_t6}{A vector of attribute names, scd T6 attributes.}

\item{is_when}{A boolean, is when dimension.}

\item{...}{When dimension configuration parameters.}
}
\value{
A \code{dimension_schema} object.
}
\description{
A \code{dimension_schema} object is created, we have to define its name and the
set of attributes that make it up.
}
\details{
A \code{dimension_schema} object is part of a \code{star_schema} object, defines
a dimension of the star schema.
}
\examples{

d <- dimension_schema(
  name = "when",
  attributes = c(
    "Week Ending Date",
    "WEEK",
    "Year"
  )
)

}
\seealso{
\code{\link{star_database}}

Other star schema definition functions: 
\code{\link{define_dimension}()},
\code{\link{define_facts}()},
\code{\link{fact_schema}()},
\code{\link{star_schema}()}
}
\concept{star schema definition functions}
