% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_step.r
\name{step}
\alias{step}
\title{Numerical Integration Over a Single Time Step}
\arguments{
\item{t0}{Numeric. Initial time.}

\item{h}{Numeric. Length of time step of interest.}

\item{hmin}{Minimum tolerated internal step size. The default of \code{NULL}
sets this to 10 times the value of \code{.Machine$double.eps}.}

\item{maxsteps}{Maximum tolerated number of sub-steps.}

\item{tol}{Numeric. Relative accuracy requested. This is currently a global value, i.e.
one cannot set the accuracy per state variable.}

\item{method}{String. Currently, 'rk5' is the only method implemented. This is
a Runge-Kutta Cash-Karp solver adapted from Press et al. (2002), Numerical
recipes in Fortran 90. It is designed to handle non-stiff problems only.}

\item{check}{Logical. Can be used to avoid repeated checks of arguments. This
may increase performance in repeated calls.}
}
\value{
A named numeric vector holding the values of state variables and
  process rates in all boxes.
}
\description{
Performs integration over a single time step using a built-in ODE solver.
At present, a single solver is implement with limited options. The interface
of this method may change when support for other solvers is added.
}
\note{
This method can only be used after a call to \code{\link{initStepper}}
  has been made.
}
\seealso{
Use \code{\link[deSolve]{deSolve}} for advanced solvers with more
  options and capabilities to handle stiff problems.
}
\author{
\email{david.kneis@tu-dresden.de}
}
