% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethod_initialize.r
\name{initialize}
\alias{initialize}
\alias{new}
\title{Initialize a \code{rodeo} Object}
\arguments{
\item{vars}{Declaration of state variables appearing in the ODE system.
Data frame with mandatory columns 'name', 'unit', 'description'.}

\item{pars}{Declaration of parameters (i.e. constants) appearing in the ODE
system. Data frame with the same mandatory columns as \code{vars}.}

\item{funs}{Declaration of functions being referenced in the ODE
system. Data frame with the same mandatory columns as \code{vars} or
\code{NULL} if no function calls are present at the ODEs' right-hand sides.}

\item{pros}{Declaration of process rates. Data frame with mandatory columns
'name', 'unit', 'description', 'expression'.}

\item{stoi}{Declaration of stoichiometric factors. A data frame with
mandatory columns 'variable', 'process', 'expression', if \code{asMatrix}
is \code{FALSE}. The 'expression' colum holds the stoichiometric factors.
If \code{asMatrix} is \code{TRUE}, this must be a matrix of type character
with row names (processes) and colum names (variables). Empty or \code{NA}
matrix elements are interpreted as zero stoichiometry factors.}

\item{asMatrix}{Logical. Specifies whether stoichiometry information is given
in matrix or data base format.}

\item{dim}{An integer vector, specifying the number of boxes in each spatial
dimension. Use \code{c(1)} to create a zero-dimensional
(i.e. single-box) model. This is the default.
Use, e.g. \code{c(5)} to create a 1-dimensional model with 5 boxes.
To create, e.g., a 2-dimensional model with 4 x 5 boxes, use \code{c(4,5)}.}
}
\value{
The method is called implicitly for its side effects when a
  \code{\link{rodeo}} object is instantiated with \code{\link[methods]{new}}.
  It has no accessible return value.
}
\description{
Initializes an object of the \code{\link{rodeo-class}} with data frames
holding the specification of an ODE system.
}
\note{
The mandatory fields of the input data frames should be of type
  character. Additional fields may be present in these data frames and the
  contents becomes part of the \code{\link{rodeo}} object.
  The 'expression' fields of \code{pros} and \code{stoi} (or the contents of
  the stoichiometry matrix) should be valid mathematical expressions in R and
  Fortran. These can involve the names of declared state variables,
  parameters, and functions as well as numeric constants or basic math
  operators. Branching or loop constructs are not allowed (but these can
  appear inside referenced functions).
  There are currently few reserved words that cannot be used as variable,
  parameter, function, or process names. The reserved words are 'time',
  'left', and 'right'.

Initialization does not assign numeric values to state variables or
  parameters. Use the decicated methods \code{\link{setVars}} and 
  \code{\link{setPars}} for that purpose.
}
\examples{
data(vars, pars, funs, pros, stoi)
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
print(model)
}
\seealso{
See the package vignette for examples.
}
\author{
\email{david.kneis@tu-dresden.de}
}
