% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{rockr.assign.expr}
\alias{rockr.assign.expr}
\title{Assign an R expression}
\usage{
rockr.assign.expr(conn, symbol, value, async = FALSE)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{symbol}{Name of the R symbol.}

\item{value}{Value to assign to the symbol: can be a primitive value or a R script to execute.}

\item{async}{R script is executed asynchronously within the session (default is FALSE).
If TRUE, the value returned is the ID of the command to look for.}
}
\value{
The command object if async is TRUE
}
\description{
Assign an R expression to a symbol in the remote R session.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
rockr.assign.expr(conn, "x", 123)
rockr.assign.expr(conn, "y", "abc")
rockr.assign.expr(conn, "z", quote(tibble::tribble(
  ~colA, ~colB,
  'a',   1,
  'b',   2,
  'c',   3
)))
rockr.close(conn)
}
}
\seealso{
Other assignment functions: 
\code{\link{rockr.assign.data}()},
\code{\link{rockr.assign}()}
}
\concept{assignment functions}
