\name{optimal_alpha}
\alias{optimal_alpha}
\title{Selecting an Optimal \eqn{\alpha} for MDPDE}
\usage{
optimal_alpha(formula, data = NULL, base_alpha = 0.5, B = 99, s_level = 0.1)
}
\arguments{
  \item{formula}{A symbolic description of the model to be estimated,
    specified using the standard R formula syntax (e.g., y ~ x1 + x2).}

  \item{data}{A data frame containing the variables in the model.}

  \item{base_alpha}{A numeric value. This selection procedure includes 
  a bootstrap test. The bootstrap samples are generated using the MDPD
  estimates with \eqn{\alpha} = \code{base_alpha}, and the procedure 
  selects an optimal \eqn{\alpha} from the set \{0, 0.05, 0.1, ..., 
  \code{base_alpha}\}.} 

  \item{B}{A numeric. This selecting procedure includes a bootstrap
    test, where B is the number of the bootstrap replications required for
    calculating a critical value. The default value is 99.}

  \item{s_level}{A numeric value representing the significance level for
    the bootstrap test. The default value is 0.1.}
}
\value{
  A character string indicating the recommended optimal \eqn{\alpha} for MDPD
  estimation, selected from the set \{0, 0.05, 0.1, ...,\code{base_alpha}\}.
}
\description{
This function recommends an optimal \eqn{\alpha} for performing MDPD estimation.
The function repeatedly calls \code{bootstrap_test} and selects the optimal
\eqn{\alpha} from the set \{0, 0.05, 0.1, ..., specified \eqn{\alpha}\}.
}
\examples{
\donttest{
## Example using the 'riceProdPhil' dataset from the `frontier` package
library(frontier)
data(riceProdPhil)

## It takes to time to get the result of the optimal_alpha() function.
my.model <- log(PROD) ~ log(AREA) + log(LABOR) + log(NPK) + log(OTHER)
optimal_alpha(my.model, data = riceProdPhil, base_alpha=0.5)


## Data with a single outlying observation
riceProdPhil2 <- riceProdPhil
riceProdPhil3 <- riceProdPhil

idx <- which.max(riceProdPhil$PROD)
riceProdPhil2$PROD[idx] <- riceProdPhil$PROD[idx]*10
riceProdPhil3$PROD[idx] <- riceProdPhil$PROD[idx]/100

optimal_alpha(my.model, data = riceProdPhil2, base_alpha=0.5)
optimal_alpha(my.model, data = riceProdPhil3, base_alpha=0.5)
}
}
%\references{
%  Durio, A. & Isaia, E.D. (2011). The minimum density power divergence
%  approach in building robust regression models. Informatica, 22, 43-56.
%}
